/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetryBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import java.util.Objects;

public interface OpenTelemetry {
    public static OpenTelemetry get() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry();
    }

    public static void set(OpenTelemetry openTelemetry) {
        DefaultOpenTelemetry.setGlobalOpenTelemetry(openTelemetry);
    }

    public static TracerProvider getGlobalTracerProvider() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracerProvider();
    }

    public static Tracer getGlobalTracer(String instrumentationName) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracer(instrumentationName);
    }

    public static Tracer getGlobalTracer(String instrumentationName, String instrumentationVersion) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getTracer(instrumentationName, instrumentationVersion);
    }

    public static MeterProvider getGlobalMeterProvider() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeterProvider();
    }

    public static Meter getGlobalMeter(String instrumentationName) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeter(instrumentationName);
    }

    public static Meter getGlobalMeter(String instrumentationName, String instrumentationVersion) {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getMeter(instrumentationName, instrumentationVersion);
    }

    public static ContextPropagators getGlobalPropagators() {
        return DefaultOpenTelemetry.getGlobalOpenTelemetry().getPropagators();
    }

    public static void setGlobalPropagators(ContextPropagators propagators) {
        Objects.requireNonNull(propagators, "propagators");
        OpenTelemetry.get().setPropagators(propagators);
    }

    public void setPropagators(ContextPropagators var1);

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationName) {
        return this.getTracerProvider().get(instrumentationName);
    }

    default public Tracer getTracer(String instrumentationName, String instrumentationVersion) {
        return this.getTracerProvider().get(instrumentationName, instrumentationVersion);
    }

    public MeterProvider getMeterProvider();

    default public Meter getMeter(String instrumentationName) {
        return this.getMeterProvider().get(instrumentationName);
    }

    default public Meter getMeter(String instrumentationName, String instrumentationVersion) {
        return this.getMeterProvider().get(instrumentationName, instrumentationVersion);
    }

    public ContextPropagators getPropagators();

    @Deprecated
    public OpenTelemetryBuilder<?> toBuilder();

    public static OpenTelemetryBuilder<?> builder() {
        return new DefaultOpenTelemetry.Builder();
    }
}

