/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.concurrent;

import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.api.concurrent.State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExecutorInstrumentationUtils {
    public static boolean shouldAttachStateToTask(Object task) {
        if (task == null) {
            return false;
        }
        Class<?> taskClass = task.getClass();
        Class<?> enclosingClass = taskClass.getEnclosingClass();
        return Context.current() != Context.root() && !taskClass.getName().equals("org.apache.tomcat.util.net.NioEndpoint$SocketProcessor") && (enclosingClass == null || !enclosingClass.getName().equals("io.netty.util.concurrent.SingleThreadEventExecutor"));
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, Context context) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            List<StackTraceElement[]> locations = ContextPropagationDebug.getLocations(context);
            if (locations == null) {
                locations = new CopyOnWriteArrayList<StackTraceElement[]>();
                context = ContextPropagationDebug.withLocations(locations, context);
            }
            locations.add(0, new Exception().getStackTrace());
        }
        state.setParentContext(context);
        return state;
    }

    public static void cleanUpOnMethodExit(State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.clearParentContext();
        }
    }
}

