/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.ClassInjector;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.InjectionMode;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.ProxyInjectionBuilder;
import io.opentelemetry.javaagent.tooling.HelperClassDefinition;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyBootstrap;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyProxyFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import io.opentelemetry.javaagent.tooling.muzzle.AgentTooling;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.pool.TypePool;

public class ClassInjectorImpl
implements ClassInjector {
    private final InstrumentationModule instrumentationModule;
    private final List<Function<ClassLoader, HelperClassDefinition>> classesToInject;
    private final IndyProxyFactory proxyFactory;

    public ClassInjectorImpl(InstrumentationModule module) {
        this.instrumentationModule = module;
        this.classesToInject = new ArrayList<Function<ClassLoader, HelperClassDefinition>>();
        this.proxyFactory = IndyBootstrap.getProxyFactory(module);
    }

    public List<HelperClassDefinition> getClassesToInject(ClassLoader instrumentedCl) {
        return this.classesToInject.stream().map(generator -> (HelperClassDefinition)generator.apply(instrumentedCl)).collect(Collectors.toList());
    }

    public ProxyInjectionBuilder proxyBuilder(String classToProxy, String newProxyName) {
        return new ProxyBuilder(classToProxy, newProxyName);
    }

    private class ProxyBuilder
    implements ProxyInjectionBuilder {
        private final String classToProxy;
        private final String proxyClassName;

        ProxyBuilder(String classToProxy, String proxyClassName) {
            this.classToProxy = classToProxy;
            this.proxyClassName = proxyClassName;
        }

        public void inject(InjectionMode mode) {
            ClassInjectorImpl.this.classesToInject.add(cl -> {
                InstrumentationModuleClassLoader moduleCl = IndyModuleRegistry.getInstrumentationClassLoader(ClassInjectorImpl.this.instrumentationModule, cl);
                TypePool typePool = AgentTooling.poolStrategy().typePool(AgentTooling.locationStrategy().classFileLocator((ClassLoader)moduleCl), (ClassLoader)moduleCl);
                TypeDescription proxiedType = typePool.describe(this.classToProxy).resolve();
                DynamicType.Unloaded<?> proxy = ClassInjectorImpl.this.proxyFactory.generateProxy(proxiedType, this.proxyClassName);
                return HelperClassDefinition.create(proxy, (InjectionMode)mode);
            });
        }
    }
}

