/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.util;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Ownership;
import net.bytebuddy.description.modifier.Visibility;

class ClassLoaderMap {
    private static final Cache<ClassLoader, WeakReference<Map<Object, Object>>> data = Cache.weak();
    private static final Map<Object, Object> bootLoaderData = new ConcurrentHashMap<Object, Object>();
    private static final HelperInjector helperInjector = HelperInjector.forDynamicTypes((String)ClassLoaderMap.class.getSimpleName(), Collections.emptyList(), null);
    static Injector defaultInjector = (classLoader, className, bytes) -> {
        helperInjector.injectHelperClasses(classLoader, Collections.singletonMap(className, () -> bytes));
        return Class.forName(className, false, classLoader);
    };

    public static Object get(ClassLoader classLoader, Injector classInjector, Object key) {
        return ClassLoaderMap.getClassLoaderData(classLoader, classInjector, false).get(key);
    }

    public static void put(ClassLoader classLoader, Injector classInjector, Object key, Object value) {
        ClassLoaderMap.getClassLoaderData(classLoader, classInjector, true).put(key, value);
    }

    public static Object computeIfAbsent(ClassLoader classLoader, Injector classInjector, Object key, Supplier<? extends Object> value) {
        return ClassLoaderMap.getClassLoaderData(classLoader, classInjector, true).computeIfAbsent(key, unused -> value.get());
    }

    private static Map<Object, Object> getClassLoaderData(ClassLoader classLoader, Injector classInjector, boolean initialize) {
        Map<Object, Object> map;
        if (classLoader == null) {
            return bootLoaderData;
        }
        WeakReference weakReference = (WeakReference)data.get((Object)classLoader);
        Map<Object, Object> map2 = map = weakReference != null ? (Map<Object, Object>)weakReference.get() : null;
        if (map == null) {
            if (!initialize) {
                return Collections.emptyMap();
            }
            map = ClassLoaderMap.createMap(classLoader, classInjector);
            data.put((Object)classLoader, new WeakReference<Map<Object, Object>>(map));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Object, Object> createMap(ClassLoader classLoader, Injector classInjector) {
        ConcurrentHashMap<Object, Object> map;
        String className = "io.opentelemetry.javaagent.ClassLoaderData$$" + Integer.toHexString(System.identityHashCode(classLoader));
        byte[] bytes = new ByteBuddy().subclass(Object.class).name(className).defineField("data", Object.class, new ModifierContributor.ForField[]{Ownership.STATIC, Visibility.PUBLIC}).make().getBytes();
        try {
            Class<?> clazz = classInjector.inject(classLoader, className, bytes);
            Field field = clazz.getField("data");
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                map = (ConcurrentHashMap<Object, Object>)field.get(classLoader);
                if (map == null) {
                    map = new ConcurrentHashMap<Object, Object>();
                    field.set(null, map);
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return map;
    }

    private ClassLoaderMap() {
    }

    @FunctionalInterface
    static interface Injector {
        public Class<?> inject(ClassLoader var1, String var2, byte[] var3) throws Exception;
    }
}

