/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.http;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.bootstrap.internal.AgentInstrumentationConfig;
import io.opentelemetry.javaagent.tooling.BeforeAgentListener;
import io.opentelemetry.javaagent.tooling.instrumentation.http.UrlTemplateRules;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@AutoService(value={BeforeAgentListener.class})
public final class RegexUrlTemplateCustomizerInitializer
implements BeforeAgentListener {
    private static final Logger logger = Logger.getLogger(RegexUrlTemplateCustomizerInitializer.class.getName());

    @Override
    public void beforeAgent(AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk) {
        InstrumentationConfig config = AgentInstrumentationConfig.get();
        boolean urlTemplateEnabled = config.getBoolean("otel.instrumentation.http.client.emit-experimental-telemetry", false);
        if (!urlTemplateEnabled || !config.isDeclarative()) {
            return;
        }
        DeclarativeConfigProperties configuration = config.getDeclarativeConfig("http").getStructured("client", DeclarativeConfigProperties.empty());
        configuration.getStructuredList("url_template_rules", Collections.emptyList()).forEach(rule -> {
            String patternString = rule.getString("pattern", "");
            String template = rule.getString("template", "");
            if (patternString.isEmpty() || template.isEmpty()) {
                return;
            }
            boolean override = rule.getBoolean("override", false);
            Pattern pattern = RegexUrlTemplateCustomizerInitializer.toPattern(patternString);
            if (pattern != null) {
                UrlTemplateRules.addRule(pattern, template, override);
            }
        });
    }

    private static Pattern toPattern(String patternString) {
        try {
            if (!patternString.startsWith("^")) {
                patternString = "^" + patternString;
            }
            if (!patternString.endsWith("$")) {
                patternString = patternString + "$";
            }
            return Pattern.compile(patternString);
        }
        catch (PatternSyntaxException exception) {
            logger.log(Level.WARNING, "Invalid pattern in http client url template customization rule \"" + patternString + "\".", exception);
            return null;
        }
    }
}

