/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.bootstrap.field.VirtualFieldAccessorMarker;
import io.opentelemetry.javaagent.tooling.field.FieldBackedImplementationConfiguration;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import io.opentelemetry.javaagent.tooling.muzzle.ClassFileLocatorProvider;
import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import org.jetbrains.annotations.Nullable;

@AutoService(value={ClassFileLocatorProvider.class})
public final class FieldBackedImplementationClassFileLocatorProvider
implements ClassFileLocatorProvider {
    @Nullable
    public ClassFileLocator getClassFileLocator() {
        if (!FieldBackedImplementationConfiguration.fieldInjectionEnabled) {
            return null;
        }
        return new VirtualFieldInterfaceLocator();
    }

    private static class VirtualFieldInterfaceLocator
    implements ClassFileLocator {
        private static final ByteBuddy byteBuddy = new ByteBuddy();

        private VirtualFieldInterfaceLocator() {
        }

        private static DynamicType.Unloaded<?> makeFieldAccessorInterface(String name) {
            return byteBuddy.makeInterface().merge(new ModifierContributor.ForType[]{SyntheticState.SYNTHETIC}).name(name).implement(new Type[]{VirtualFieldAccessorMarker.class}).make();
        }

        public ClassFileLocator.Resolution locate(String name) {
            if (GeneratedVirtualFieldNames.isVirtualFieldInterfaceName(name)) {
                try (DynamicType.Unloaded<?> type = VirtualFieldInterfaceLocator.makeFieldAccessorInterface(name);){
                    ClassFileLocator.Resolution.Explicit explicit = new ClassFileLocator.Resolution.Explicit(type.getBytes());
                    return explicit;
                }
            }
            return new ClassFileLocator.Resolution.Illegal(name);
        }

        public void close() {
        }
    }
}

