/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.instrumentation.config.bridge.DeclarativeConfigPropertiesBridgeBuilder;
import io.opentelemetry.javaagent.bootstrap.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.tooling.config.EarlyInitAgentConfig;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.SdkAutoconfigureAccess;
import io.opentelemetry.sdk.autoconfigure.internal.AutoConfigureUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Arrays;

public final class OpenTelemetryInstaller {
    public static AutoConfiguredOpenTelemetrySdk installOpenTelemetrySdk(ClassLoader extensionClassLoader, EarlyInitAgentConfig earlyConfig) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredSdk = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal().setServiceClassLoader(extensionClassLoader).build();
        ConfigProvider configProvider = AutoConfigureUtil.getConfigProvider((AutoConfiguredOpenTelemetrySdk)autoConfiguredSdk);
        OpenTelemetrySdk sdk = autoConfiguredSdk.getOpenTelemetrySdk();
        OpenTelemetryInstaller.setForceFlush(sdk);
        if (configProvider != null) {
            return SdkAutoconfigureAccess.create(sdk, SdkAutoconfigureAccess.getResource(autoConfiguredSdk), OpenTelemetryInstaller.getDeclarativeConfigBridgedProperties(earlyConfig, configProvider), configProvider);
        }
        return autoConfiguredSdk;
    }

    static ConfigProperties getDeclarativeConfigBridgedProperties(EarlyInitAgentConfig earlyConfig, ConfigProvider configProvider) {
        return new DeclarativeConfigPropertiesBridgeBuilder().addMapping("otel.javaagent", "agent").addOverride("otel.instrumentation.common.default-enabled", (Object)OpenTelemetryInstaller.defaultEnabled(configProvider)).addOverride("otel.javaagent.debug", (Object)earlyConfig.getBoolean("otel.javaagent.debug", false)).addOverride("otel.javaagent.logging", (Object)earlyConfig.getString("otel.javaagent.logging")).buildFromInstrumentationConfig(configProvider.getInstrumentationConfig());
    }

    private static boolean defaultEnabled(ConfigProvider configProvider) {
        String mode;
        DeclarativeConfigProperties instrumentationConfig = configProvider.getInstrumentationConfig();
        if (instrumentationConfig == null) {
            return true;
        }
        switch (mode = instrumentationConfig.getStructured("java", DeclarativeConfigProperties.empty()).getStructured("agent", DeclarativeConfigProperties.empty()).getString("instrumentation_mode", "default")) {
            case "none": {
                return false;
            }
            case "default": {
                return true;
            }
        }
        throw new ConfigurationException("Unknown instrumentation mode: " + mode);
    }

    private static void setForceFlush(OpenTelemetrySdk sdk) {
        OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> {
            CompletableResultCode traceResult = sdk.getSdkTracerProvider().forceFlush();
            CompletableResultCode metricsResult = sdk.getSdkMeterProvider().forceFlush();
            CompletableResultCode logsResult = sdk.getSdkLoggerProvider().forceFlush();
            CompletableResultCode.ofAll(Arrays.asList(traceResult, metricsResult, logsResult)).join(timeout, unit);
        });
    }

    private OpenTelemetryInstaller() {
    }
}

