/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent.builder;

import io.opentelemetry.javaagent.extension.matcher.internal.DelegatingMatcher;
import io.opentelemetry.javaagent.extension.matcher.internal.DelegatingSuperTypeMatcher;
import io.opentelemetry.javaagent.tooling.DefineClassHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ErasureMatcher;
import net.bytebuddy.matcher.HasSuperClassMatcher;
import net.bytebuddy.matcher.NameMatcher;
import net.bytebuddy.matcher.StringMatcher;
import net.bytebuddy.matcher.StringSetMatcher;
import net.bytebuddy.utility.JavaModule;

public class AgentBuilderUtil {
    private static final Logger logger = Logger.getLogger(AgentBuilderUtil.class.getName());
    private static final Field agentBuilderTransformationsField = AgentBuilderUtil.getField(AgentBuilder.Default.class, "transformations");
    private static final Field rawConjunctionMatchersField = AgentBuilderUtil.getField(AgentBuilder.RawMatcher.Conjunction.class, "matchers");
    private static final Field forElementMatcherField = AgentBuilderUtil.getField(AgentBuilder.RawMatcher.ForElementMatchers.class, "typeMatcher");
    private static final Field nameMatcherField = AgentBuilderUtil.getField(NameMatcher.class, "matcher");
    private static final Field hasSuperClassMatcherField = AgentBuilderUtil.getField(HasSuperClassMatcher.class, "matcher");
    private static final Field erasureMatcherField = AgentBuilderUtil.getField(ErasureMatcher.class, "matcher");
    private static final Field conjunctionMatchersField = AgentBuilderUtil.getField(ElementMatcher.Junction.Conjunction.class, "matchers");
    private static final Field stringMatcherValueField = AgentBuilderUtil.getField(StringMatcher.class, "value");
    private static final Field stringMatcherModeField = AgentBuilderUtil.getField(StringMatcher.class, "mode");
    private static final Field stringSetMatcherValuesField = AgentBuilderUtil.getField(StringSetMatcher.class, "values");

    private AgentBuilderUtil() {
    }

    public static AgentBuilder optimize(AgentBuilder agentBuilder) {
        try {
            agentBuilder = agentBuilder.with((AgentBuilder.Listener)new TransformContext());
            AgentBuilderUtil.optimize((AgentBuilder.Default)agentBuilder);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to optimize transformations", exception);
        }
        return agentBuilder;
    }

    private static void optimize(AgentBuilder.Default agentBuilder) throws Exception {
        HashSet<String> classNames = new HashSet<String>();
        HashSet<String> superTypeNames = new HashSet<String>();
        ArrayList<AgentBuilder.Default.Transformation> unoptimizedTransformations = new ArrayList<AgentBuilder.Default.Transformation>();
        List transformations = agentBuilder.transformations;
        for (AgentBuilder.Default.Transformation transformation : transformations) {
            AgentBuilder.RawMatcher matcher = transformation.getMatcher();
            Result result = AgentBuilderUtil.inspect(matcher);
            if (result == null) {
                unoptimizedTransformations.add(transformation);
                continue;
            }
            if (result.subtype) {
                superTypeNames.addAll(result.names);
                continue;
            }
            classNames.addAll(result.names);
        }
        List list = (List)Proxy.newProxyInstance(AgentBuilderUtil.class.getClassLoader(), new Class[]{List.class}, (proxy, method, args) -> {
            String name = TransformContext.getTransformedClassName();
            if (name != null && "iterator".equals(method.getName())) {
                if (classNames.contains(name) || superTypeNames.contains(name)) {
                    return transformations.iterator();
                }
                if (DefineClassHandler.isFailedClass(name)) {
                    return Collections.emptyIterator();
                }
                Set<String> loadingSuperTypes = DefineClassHandler.getSuperTypes();
                if (loadingSuperTypes.isEmpty()) {
                    return transformations.iterator();
                }
                for (String className : loadingSuperTypes) {
                    if (!superTypeNames.contains(className)) continue;
                    return transformations.iterator();
                }
                return unoptimizedTransformations.iterator();
            }
            return method.invoke((Object)transformations, args);
        });
        agentBuilderTransformationsField.set(agentBuilder, list);
    }

    @Nullable
    private static Result inspect(AgentBuilder.RawMatcher matcher) throws Exception {
        if (matcher instanceof AgentBuilder.RawMatcher.Conjunction) {
            List<AgentBuilder.RawMatcher> matchers = AgentBuilderUtil.getDelegateMatchers(matcher);
            if (!matchers.isEmpty()) {
                return AgentBuilderUtil.inspect(matchers.get(0));
            }
        } else if (matcher instanceof AgentBuilder.RawMatcher.ForElementMatchers) {
            ElementMatcher<?> elementMatcher = AgentBuilderUtil.getDelegateMatcher((AgentBuilder.RawMatcher.ForElementMatchers)matcher);
            Result result = AgentBuilderUtil.inspect(elementMatcher);
            if (result == null && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not decompose matcher {0}", elementMatcher);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static Result inspect(ElementMatcher<?> matcher) throws Exception {
        if (matcher instanceof DelegatingMatcher) {
            Result result = AgentBuilderUtil.inspect(((DelegatingMatcher)matcher).getDelegate());
            if (matcher instanceof DelegatingSuperTypeMatcher) {
                return Result.subtype(result);
            }
            return result;
        }
        if (matcher instanceof HasSuperClassMatcher) {
            return Result.subtype(AgentBuilderUtil.inspect(AgentBuilderUtil.getDelegateMatcher((HasSuperClassMatcher)matcher)));
        }
        if (matcher instanceof ErasureMatcher) {
            return AgentBuilderUtil.inspect(AgentBuilderUtil.getDelegateMatcher((ErasureMatcher)matcher));
        }
        if (matcher instanceof NameMatcher) {
            return AgentBuilderUtil.inspectNameMatcher((NameMatcher)matcher);
        }
        if (matcher instanceof ElementMatcher.Junction.Conjunction) {
            List<ElementMatcher<?>> matchers = AgentBuilderUtil.getDelegateMatchers((ElementMatcher.Junction.Conjunction)matcher);
            for (ElementMatcher<?> elementMatcher : matchers) {
                Result result = AgentBuilderUtil.inspect(elementMatcher);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    private static Result inspectNameMatcher(NameMatcher<?> nameMatcher) throws Exception {
        ElementMatcher<?> matcher = AgentBuilderUtil.getDelegateMatcher(nameMatcher);
        if (matcher instanceof StringMatcher) {
            String value = AgentBuilderUtil.getStringMatcherValue((StringMatcher)matcher);
            return Result.named(value);
        }
        if (matcher instanceof StringSetMatcher) {
            Set<String> value = AgentBuilderUtil.getStringSetMatcherValue((StringSetMatcher)matcher);
            return Result.named(value);
        }
        return null;
    }

    private static ElementMatcher<?> getDelegateMatcher(AgentBuilder.RawMatcher.ForElementMatchers matcher) throws Exception {
        return (ElementMatcher)forElementMatcherField.get(matcher);
    }

    private static ElementMatcher<?> getDelegateMatcher(NameMatcher<?> matcher) throws Exception {
        return (ElementMatcher)nameMatcherField.get(matcher);
    }

    private static ElementMatcher<?> getDelegateMatcher(HasSuperClassMatcher<?> matcher) throws Exception {
        return (ElementMatcher)hasSuperClassMatcherField.get(matcher);
    }

    private static ElementMatcher<?> getDelegateMatcher(ErasureMatcher<?> matcher) throws Exception {
        return (ElementMatcher)erasureMatcherField.get(matcher);
    }

    private static List<AgentBuilder.RawMatcher> getDelegateMatchers(AgentBuilder.RawMatcher matcher) throws Exception {
        return (List)rawConjunctionMatchersField.get(matcher);
    }

    private static List<ElementMatcher<?>> getDelegateMatchers(ElementMatcher.Junction.Conjunction<?> matcher) throws Exception {
        return (List)conjunctionMatchersField.get(matcher);
    }

    @Nullable
    private static String getStringMatcherValue(StringMatcher matcher) throws Exception {
        String value = (String)stringMatcherValueField.get(matcher);
        StringMatcher.Mode mode = (StringMatcher.Mode)stringMatcherModeField.get(matcher);
        return mode == StringMatcher.Mode.EQUALS_FULLY ? value : null;
    }

    private static Set<String> getStringSetMatcherValue(StringSetMatcher matcher) throws Exception {
        return (Set)stringSetMatcherValuesField.get(matcher);
    }

    private static Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TransformContext
    extends AgentBuilder.Listener.Adapter {
        private static final ThreadLocal<String> transformedName = new ThreadLocal();

        private TransformContext() {
        }

        @Nullable
        static String getTransformedClassName() {
            return transformedName.get();
        }

        public void onDiscovery(String typeName, @Nullable ClassLoader classLoader, @Nullable JavaModule module, boolean loaded) {
            if (classLoader != null) {
                transformedName.set(typeName);
            }
        }

        public void onError(String typeName, @Nullable ClassLoader classLoader, @Nullable JavaModule module, boolean loaded, Throwable throwable) {
            transformedName.remove();
        }

        public void onComplete(String typeName, @Nullable ClassLoader classLoader, @Nullable JavaModule module, boolean loaded) {
            transformedName.remove();
        }
    }

    private static class Result {
        final Set<String> names = new HashSet<String>();
        final boolean subtype;

        private Result(boolean subtype) {
            this.subtype = subtype;
        }

        private Result() {
            this(false);
        }

        @Nullable
        static Result subtype(@Nullable Result value) {
            if (value == null) {
                return null;
            }
            Result result = new Result(true);
            result.names.addAll(value.names);
            return result;
        }

        @Nullable
        static Result named(@Nullable String value) {
            if (value == null) {
                return null;
            }
            Result result = new Result();
            result.names.add(value);
            return result;
        }

        @Nullable
        static Result named(@Nullable Set<String> value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            Result result = new Result();
            result.names.addAll(value);
            return result;
        }

        public String toString() {
            return (this.subtype ? "subtype of " : "named ") + this.names;
        }
    }
}

