/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.api.incubator.config.InstrumentationConfigUtil;
import io.opentelemetry.instrumentation.api.incubator.config.internal.InstrumentationConfig;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfigPropertiesBridge
implements InstrumentationConfig {
    private final ConfigProperties configProperties;
    @Nullable
    private final ConfigProvider configProvider;

    public ConfigPropertiesBridge(ConfigProperties configProperties, @Nullable ConfigProvider configProvider) {
        this.configProperties = configProperties;
        this.configProvider = configProvider;
    }

    @Nullable
    public String getString(String name) {
        try {
            return this.configProperties.getString(name);
        }
        catch (ConfigurationException ignored) {
            return null;
        }
    }

    public String getString(String name, String defaultValue) {
        try {
            return this.configProperties.getString(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            return this.configProperties.getBoolean(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public int getInt(String name, int defaultValue) {
        try {
            return this.configProperties.getInt(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        try {
            return this.configProperties.getLong(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public double getDouble(String name, double defaultValue) {
        try {
            return this.configProperties.getDouble(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public Duration getDuration(String name, Duration defaultValue) {
        try {
            return this.configProperties.getDuration(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public List<String> getList(String name, List<String> defaultValue) {
        try {
            return this.configProperties.getList(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public Map<String, String> getMap(String name, Map<String, String> defaultValue) {
        try {
            return this.configProperties.getMap(name, defaultValue);
        }
        catch (ConfigurationException ignored) {
            return defaultValue;
        }
    }

    public boolean isDeclarative() {
        return this.configProvider != null;
    }

    public DeclarativeConfigProperties getDeclarativeConfig(String node) {
        DeclarativeConfigProperties config = InstrumentationConfigUtil.javaInstrumentationConfig((ConfigProvider)this.configProvider, (String)node);
        if (config == null) {
            return DeclarativeConfigProperties.empty();
        }
        return config;
    }

    @Nullable
    public ConfigProvider getConfigProvider() {
        return this.configProvider;
    }
}

