/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.asyncannotationsupport;

import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategies;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.annotation.support.async.Jdk8AsyncOperationEndStrategy;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

public final class WeakRefAsyncOperationEndStrategies
extends AsyncOperationEndStrategies {
    private final List<WeakReference<AsyncOperationEndStrategy>> strategies = new CopyOnWriteArrayList<WeakReference<AsyncOperationEndStrategy>>();

    public static void initialize() {
        AsyncOperationEndStrategies.internalSetStrategiesStorage((AsyncOperationEndStrategies)new WeakRefAsyncOperationEndStrategies());
    }

    private WeakRefAsyncOperationEndStrategies() {
        this.registerStrategy((AsyncOperationEndStrategy)Jdk8AsyncOperationEndStrategy.INSTANCE);
    }

    public void registerStrategy(AsyncOperationEndStrategy strategy) {
        this.strategies.add(new WeakReference<AsyncOperationEndStrategy>(strategy));
    }

    public void unregisterStrategy(AsyncOperationEndStrategy strategy) {
        this.strategies.removeIf(ref -> {
            AsyncOperationEndStrategy s = (AsyncOperationEndStrategy)ref.get();
            return s == null || s == strategy;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AsyncOperationEndStrategy resolveStrategy(Class<?> returnType) {
        boolean purgeCollectedWeakReferences = false;
        try {
            for (WeakReference<AsyncOperationEndStrategy> ref2 : this.strategies) {
                AsyncOperationEndStrategy s = (AsyncOperationEndStrategy)ref2.get();
                if (s == null) {
                    purgeCollectedWeakReferences = true;
                    continue;
                }
                if (!s.supports(returnType)) continue;
                AsyncOperationEndStrategy asyncOperationEndStrategy = s;
                return asyncOperationEndStrategy;
            }
            Iterator<WeakReference<AsyncOperationEndStrategy>> iterator = null;
            return iterator;
        }
        finally {
            if (purgeCollectedWeakReferences) {
                this.strategies.removeIf(ref -> ref.get() == null);
            }
        }
    }
}

