/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import io.opentelemetry.javaagent.tooling.ignore.IgnoreAllow;
import io.opentelemetry.javaagent.tooling.ignore.trie.Trie;
import java.util.regex.Pattern;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

public class IgnoredTypesMatcher
extends ElementMatcher.Junction.AbstractBase<TypeDescription> {
    private static final Pattern COM_MCHANGE_PROXY = Pattern.compile("com\\.mchange\\.v2\\.c3p0\\..*Proxy");
    private final Trie<IgnoreAllow> ignoredTypes;

    public IgnoredTypesMatcher(Trie<IgnoreAllow> ignoredTypes) {
        this.ignoredTypes = ignoredTypes;
    }

    public boolean matches(TypeDescription target) {
        String name = target.getActualName();
        IgnoreAllow ignored = this.ignoredTypes.getOrNull(name);
        if (ignored == IgnoreAllow.ALLOW) {
            return false;
        }
        if (ignored == IgnoreAllow.IGNORE) {
            return true;
        }
        if (name.contains("$$")) {
            return !name.contains("$$anon$");
        }
        if (name.contains("$JaxbAccessor") || name.contains("CGLIB$$") || name.contains("javassist") || name.contains(".asm.") || name.contains("$__sisu") || name.contains("$$EnhancerByProxool$$") || name.contains("__EJB31_Generated__")) {
            return true;
        }
        return COM_MCHANGE_PROXY.matcher(name).matches();
    }
}

