/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.extension.Ordered;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SafeServiceLoader {
    private static final Logger log = LoggerFactory.getLogger(SafeServiceLoader.class);

    public static <T> List<T> load(Class<T> serviceClass) {
        ArrayList<T> result = new ArrayList<T>();
        ServiceLoader<T> services = ServiceLoader.load(serviceClass);
        Iterator<T> iter = services.iterator();
        while (iter.hasNext()) {
            try {
                result.add(iter.next());
            }
            catch (UnsupportedClassVersionError e) {
                log.debug("Unable to load instrumentation class: {}", (Object)e.getMessage());
            }
        }
        return result;
    }

    public static <T extends Ordered> List<T> loadOrdered(Class<T> serviceClass) {
        List<T> result = SafeServiceLoader.load(serviceClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    private SafeServiceLoader() {
    }
}

