/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.bootstrap.HelperResources;
import io.opentelemetry.javaagent.extension.matcher.ClassLoaderMatcher;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.utility.JavaModule;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperInjector
implements AgentBuilder.Transformer {
    private static final Logger log = LoggerFactory.getLogger(HelperInjector.class);
    private static final ClassLoader BOOTSTRAP_CLASSLOADER_PLACEHOLDER = new SecureClassLoader(null){

        public String toString() {
            return "<bootstrap>";
        }
    };
    private static final Cache<Class<?>, Boolean> injectedClasses = Cache.newBuilder().setWeakKeys().build();
    private final String requestingName;
    private final Set<String> helperClassNames;
    private final Set<String> helperResourceNames;
    private final @Nullable ClassLoader helpersSource;
    private final Map<String, byte[]> dynamicTypeMap = new LinkedHashMap<String, byte[]>();
    private final Cache<ClassLoader, Boolean> injectedClassLoaders = Cache.newBuilder().setWeakKeys().build();
    private final List<WeakReference<Object>> helperModules = new CopyOnWriteArrayList<WeakReference<Object>>();

    public HelperInjector(String requestingName, List<String> helperClassNames, List<String> helperResourceNames, ClassLoader helpersSource) {
        this.requestingName = requestingName;
        this.helperClassNames = new LinkedHashSet<String>(helperClassNames);
        this.helperResourceNames = new LinkedHashSet<String>(helperResourceNames);
        this.helpersSource = helpersSource;
    }

    public HelperInjector(String requestingName, Map<String, byte[]> helperMap) {
        this.requestingName = requestingName;
        this.helperClassNames = helperMap.keySet();
        this.dynamicTypeMap.putAll(helperMap);
        this.helperResourceNames = Collections.emptySet();
        this.helpersSource = null;
    }

    public static HelperInjector forDynamicTypes(String requestingName, Collection<DynamicType.Unloaded<?>> helpers) {
        HashMap<String, byte[]> bytes = new HashMap<String, byte[]>(helpers.size());
        for (DynamicType.Unloaded<?> helper : helpers) {
            bytes.put(helper.getTypeDescription().getName(), helper.getBytes());
        }
        return new HelperInjector(requestingName, bytes);
    }

    private Map<String, byte[]> getHelperMap() throws IOException {
        if (this.dynamicTypeMap.isEmpty()) {
            LinkedHashMap<String, byte[]> classnameToBytes = new LinkedHashMap<String, byte[]>();
            ClassFileLocator locator = ClassFileLocator.ForClassLoader.of((ClassLoader)this.helpersSource);
            for (String helperClassName : this.helperClassNames) {
                byte[] classBytes = locator.locate(helperClassName).resolve();
                classnameToBytes.put(helperClassName, classBytes);
            }
            return classnameToBytes;
        }
        return this.dynamicTypeMap;
    }

    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        if (!this.helperClassNames.isEmpty()) {
            if (classLoader == ClassLoaderMatcher.BOOTSTRAP_CLASSLOADER) {
                classLoader = BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
            }
            this.injectedClassLoaders.computeIfAbsent((Object)classLoader, cl -> {
                try {
                    log.debug("Injecting classes onto classloader {} -> {}", cl, this.helperClassNames);
                    Map<String, byte[]> classnameToBytes = this.getHelperMap();
                    Map<String, Class<?>> classes = cl == BOOTSTRAP_CLASSLOADER_PLACEHOLDER ? HelperInjector.injectBootstrapClassLoader(classnameToBytes) : HelperInjector.injectClassLoader(cl, classnameToBytes);
                    classes.values().forEach(c -> injectedClasses.put(c, (Object)Boolean.TRUE));
                    if (JavaModule.isSupported()) {
                        JavaModule javaModule = JavaModule.ofType(classes.values().iterator().next());
                        this.helperModules.add(new WeakReference<Object>(javaModule.unwrap()));
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("Error preparing helpers while processing {} for {}. Failed to inject helper classes into instance {}", new Object[]{typeDescription, this.requestingName, cl, e});
                    }
                    throw new IllegalStateException(e);
                }
                return true;
            });
            this.ensureModuleCanReadHelperModules(module);
        }
        if (!this.helperResourceNames.isEmpty()) {
            for (String resourceName : this.helperResourceNames) {
                URL resource = this.helpersSource.getResource(resourceName);
                if (resource == null) {
                    log.debug("Helper resource {} requested but not found.", (Object)resourceName);
                    continue;
                }
                log.debug("Injecting resource onto classloader {} -> {}", (Object)classLoader, (Object)resourceName);
                HelperResources.register((ClassLoader)classLoader, (String)resourceName, (URL)resource);
            }
        }
        return builder;
    }

    private static Map<String, Class<?>> injectBootstrapClassLoader(Map<String, byte[]> classnameToBytes) throws IOException {
        File tempDir = HelperInjector.createTempDir();
        try {
            Map map = ClassInjector.UsingInstrumentation.of((File)tempDir, (ClassInjector.UsingInstrumentation.Target)ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, (Instrumentation)AgentInstaller.getInstrumentation()).injectRaw(classnameToBytes);
            return map;
        }
        finally {
            HelperInjector.deleteTempDir(tempDir);
        }
    }

    private static Map<String, Class<?>> injectClassLoader(ClassLoader classLoader, Map<String, byte[]> classnameToBytes) {
        return new ClassInjector.UsingReflection(classLoader).injectRaw(classnameToBytes);
    }

    private void ensureModuleCanReadHelperModules(JavaModule target) {
        if (JavaModule.isSupported() && target != JavaModule.UNSUPPORTED && target.isNamed()) {
            for (WeakReference<Object> helperModuleReference : this.helperModules) {
                JavaModule helperModule;
                Object realModule = helperModuleReference.get();
                if (realModule == null || target.canRead(helperModule = JavaModule.of(realModule))) continue;
                log.debug("Adding module read from {} to {}", (Object)target, (Object)helperModule);
                ClassInjector.UsingInstrumentation.redefineModule((Instrumentation)AgentInstaller.getInstrumentation(), (JavaModule)target, Collections.singleton(helperModule), Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap());
            }
        }
    }

    private static File createTempDir() throws IOException {
        return Files.createTempDirectory("opentelemetry-temp-jars", new FileAttribute[0]).toFile();
    }

    private static void deleteTempDir(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            file.deleteOnExit();
        }
    }

    public static boolean isInjectedClass(Class<?> c) {
        return Boolean.TRUE.equals(injectedClasses.get(c));
    }
}

