/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.sdk.autoconfigure.spi.Ordered;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SafeServiceLoader {
    private static final Logger logger = Logger.getLogger(SafeServiceLoader.class.getName());

    public static <T> List<T> load(Class<T> serviceClass) {
        ArrayList result = new ArrayList();
        ServiceLoader<T> services = ServiceLoader.load(serviceClass);
        SafeIterator<T> iterator = new SafeIterator<T>(services.iterator());
        while (iterator.hasNext()) {
            Object service = iterator.next();
            if (service == null) continue;
            result.add(service);
        }
        return result;
    }

    public static <T extends Ordered> List<T> loadOrdered(Class<T> serviceClass) {
        List<T> result = SafeServiceLoader.load(serviceClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    private SafeServiceLoader() {
    }

    private static class SafeIterator<T>
    implements Iterator<T> {
        private final Iterator<T> delegate;

        SafeIterator(Iterator<T> iterator) {
            this.delegate = iterator;
        }

        private static void handleUnsupportedClassVersionError(UnsupportedClassVersionError unsupportedClassVersionError) {
            logger.log(Level.FINE, "Unable to load instrumentation class: {0}", unsupportedClassVersionError.getMessage());
        }

        @Override
        public boolean hasNext() {
            while (true) {
                try {
                    return this.delegate.hasNext();
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    SafeIterator.handleUnsupportedClassVersionError(unsupportedClassVersionError);
                    continue;
                }
                break;
            }
        }

        @Override
        public T next() {
            try {
                return this.delegate.next();
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                SafeIterator.handleUnsupportedClassVersionError(unsupportedClassVersionError);
                return null;
            }
        }
    }
}

