/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.collector;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.collector.ReferenceCollector;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.pool.TypePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MuzzleCodeGenerator
implements AsmVisitorWrapper {
    private static final Logger log = LoggerFactory.getLogger(MuzzleCodeGenerator.class);
    private static final String MUZZLE_REFERENCES_FIELD_NAME = "muzzleReferences";
    private static final String MUZZLE_REFERENCES_METHOD_NAME = "getMuzzleReferences";
    private static final String MUZZLE_HELPER_CLASSES_METHOD_NAME = "getMuzzleHelperClassNames";
    private static final String MUZZLE_CONTEXT_STORE_CLASSES_METHOD_NAME = "getMuzzleContextStoreClasses";

    MuzzleCodeGenerator() {
    }

    public int mergeWriter(int flags) {
        return flags | 1;
    }

    public int mergeReader(int flags) {
        return flags;
    }

    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new GenerateMuzzleMethodsAndFields(classVisitor, implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6));
    }

    private static class GenerateMuzzleMethodsAndFields
    extends ClassVisitor {
        private final boolean frames;
        private String instrumentationClassName;
        private InstrumentationModule instrumentationModule;
        private boolean generateReferencesField = true;
        private boolean generateReferencesMethod = true;
        private boolean generateHelperClassNamesMethod = true;
        private boolean generateContextStoreClassesMethod = true;
        private static final Pattern ANONYMOUS_ENUM_CONSTANT_CLASS = Pattern.compile("(?<enumClass>.*)\\$[0-9]+$");

        public GenerateMuzzleMethodsAndFields(ClassVisitor classVisitor, boolean frames) {
            super(458752, classVisitor);
            this.frames = frames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.instrumentationClassName = name;
            try {
                this.instrumentationModule = (InstrumentationModule)MuzzleCodeGenerator.class.getClassLoader().loadClass(Utils.getClassName(this.instrumentationClassName)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME.equals(name)) {
                this.generateReferencesField = false;
                log.info("The '{}' field was already found in class '{}'. Muzzle will not generate it again", (Object)MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, (Object)this.instrumentationClassName);
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME.equals(name)) {
                this.generateReferencesMethod = false;
                log.info("The '{}' method was already found in class '{}'. Muzzle will not generate it again", (Object)MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME, (Object)this.instrumentationClassName);
            }
            if (MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME.equals(name)) {
                this.generateHelperClassNamesMethod = false;
                log.info("The '{}' method was already found in class '{}'. Muzzle will not generate it again", (Object)MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME, (Object)this.instrumentationClassName);
            }
            if (MuzzleCodeGenerator.MUZZLE_CONTEXT_STORE_CLASSES_METHOD_NAME.equals(name)) {
                this.generateContextStoreClassesMethod = false;
                log.info("The '{}' method was already found in class '{}'. Muzzle will not generate it again", (Object)MuzzleCodeGenerator.MUZZLE_CONTEXT_STORE_CLASSES_METHOD_NAME, (Object)this.instrumentationClassName);
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            if ("<init>".equals(name)) {
                methodVisitor = new InitializeReferencesField(methodVisitor);
            }
            return methodVisitor;
        }

        public void visitEnd() {
            ReferenceCollector collector = this.collectReferences();
            if (this.generateReferencesField) {
                this.generateMuzzleReferencesField();
            }
            if (this.generateReferencesMethod) {
                this.generateMuzzleReferencesMethod(collector);
            }
            if (this.generateHelperClassNamesMethod) {
                this.generateMuzzleHelperClassNamesMethod(collector);
            }
            if (this.generateContextStoreClassesMethod) {
                this.generateMuzzleContextStoreClassesMethod(collector);
            }
            super.visitEnd();
        }

        private ReferenceCollector collectReferences() {
            Set adviceClassNames = this.instrumentationModule.typeInstrumentations().stream().flatMap(typeInstrumentation -> typeInstrumentation.transformers().values().stream()).collect(Collectors.toSet());
            ReferenceCollector collector = new ReferenceCollector(arg_0 -> ((InstrumentationModule)this.instrumentationModule).isHelperClass(arg_0));
            for (String adviceClass : adviceClassNames) {
                collector.collectReferencesFromAdvice(adviceClass);
            }
            for (String resource : this.instrumentationModule.helperResourceNames()) {
                collector.collectReferencesFromResource(resource);
            }
            collector.prune();
            return collector;
        }

        private void generateMuzzleHelperClassNamesMethod(ReferenceCollector collector) {
            MethodVisitor mv = super.visitMethod(1, MuzzleCodeGenerator.MUZZLE_HELPER_CLASSES_METHOD_NAME, "()[Ljava/lang/String;", null, null);
            mv.visitCode();
            List<String> helperClassNames = collector.getSortedHelperClasses();
            mv.visitLdcInsn((Object)helperClassNames.size());
            mv.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < helperClassNames.size(); ++i) {
                String helperClassName = helperClassNames.get(i);
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)i);
                mv.visitLdcInsn((Object)helperClassName);
                mv.visitInsn(83);
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void generateMuzzleReferencesMethod(ReferenceCollector collector) {
            try {
                MethodVisitor mv = super.visitMethod(33, MuzzleCodeGenerator.MUZZLE_REFERENCES_METHOD_NAME, "()[Lio/opentelemetry/javaagent/extension/muzzle/Reference;", null, null);
                mv.visitCode();
                Label start = new Label();
                Label ret = new Label();
                Label finish = new Label();
                mv.visitLabel(start);
                mv.visitInsn(1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.instrumentationClassName, MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, Type.getDescriptor(Reference[].class));
                mv.visitJumpInsn(166, ret);
                mv.visitVarInsn(25, 0);
                Reference[] references = collector.getReferences().values().toArray(new Reference[0]);
                mv.visitLdcInsn((Object)references.length);
                mv.visitTypeInsn(189, "io/opentelemetry/javaagent/extension/muzzle/Reference");
                for (int i = 0; i < references.length; ++i) {
                    String enumClassName;
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)i);
                    mv.visitTypeInsn(187, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder");
                    mv.visitInsn(89);
                    mv.visitLdcInsn((Object)references[i].getClassName());
                    mv.visitMethodInsn(183, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "<init>", "(Ljava/lang/String;)V", false);
                    for (Reference.Source source : references[i].getSources()) {
                        mv.visitLdcInsn((Object)source.getName());
                        mv.visitLdcInsn((Object)source.getLine());
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withSource", "(Ljava/lang/String;I)Lio/opentelemetry/javaagent/extension/muzzle/Reference$Builder;", false);
                    }
                    for (Reference.Flag flag : references[i].getFlags()) {
                        String enumClassName2 = this.getEnumClassInternalName(flag);
                        mv.visitFieldInsn(178, enumClassName2, flag.name(), "L" + enumClassName2 + ";");
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withFlag", "(Lio/opentelemetry/javaagent/extension/muzzle/Reference$Flag;)Lio/opentelemetry/javaagent/extension/muzzle/Reference$Builder;", false);
                    }
                    if (null != references[i].getSuperName()) {
                        mv.visitLdcInsn((Object)references[i].getSuperName());
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withSuperName", "(Ljava/lang/String;)Lio/opentelemetry/javaagent/extension/muzzle/Reference$Builder;", false);
                    }
                    for (String interfaceName : references[i].getInterfaces()) {
                        mv.visitLdcInsn((Object)interfaceName);
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withInterface", "(Ljava/lang/String;)Lio/opentelemetry/javaagent/extension/muzzle/Reference$Builder;", false);
                    }
                    for (Reference.Field field : references[i].getFields()) {
                        mv.visitLdcInsn((Object)field.getSources().size());
                        mv.visitTypeInsn(189, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source");
                        int j = 0;
                        for (Reference.Source source : field.getSources()) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)j);
                            mv.visitTypeInsn(187, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source");
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)source.getName());
                            mv.visitLdcInsn((Object)source.getLine());
                            mv.visitMethodInsn(183, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source", "<init>", "(Ljava/lang/String;I)V", false);
                            mv.visitInsn(83);
                            ++j;
                        }
                        mv.visitLdcInsn((Object)field.getFlags().size());
                        mv.visitTypeInsn(189, "io/opentelemetry/javaagent/extension/muzzle/Reference$Flag");
                        j = 0;
                        for (Reference.Flag flag : field.getFlags()) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)j);
                            enumClassName = this.getEnumClassInternalName(flag);
                            mv.visitFieldInsn(178, enumClassName, flag.name(), "L" + enumClassName + ";");
                            mv.visitInsn(83);
                            ++j;
                        }
                        mv.visitLdcInsn((Object)field.getName());
                        mv.visitLdcInsn((Object)field.getType().getDescriptor());
                        mv.visitMethodInsn(184, Type.getInternalName(Type.class), "getType", Type.getMethodDescriptor((Method)Type.class.getMethod("getType", String.class)), false);
                        mv.visitLdcInsn((Object)field.isDeclared());
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withField", Type.getMethodDescriptor((Method)Reference.Builder.class.getMethod("withField", Reference.Source[].class, Reference.Flag[].class, String.class, Type.class, Boolean.TYPE)), false);
                    }
                    for (Reference.Method method : references[i].getMethods()) {
                        mv.visitLdcInsn((Object)method.getSources().size());
                        mv.visitTypeInsn(189, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source");
                        int j = 0;
                        for (Reference.Source source : method.getSources()) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)j);
                            mv.visitTypeInsn(187, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source");
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)source.getName());
                            mv.visitLdcInsn((Object)source.getLine());
                            mv.visitMethodInsn(183, "io/opentelemetry/javaagent/extension/muzzle/Reference$Source", "<init>", "(Ljava/lang/String;I)V", false);
                            mv.visitInsn(83);
                            ++j;
                        }
                        mv.visitLdcInsn((Object)method.getFlags().size());
                        mv.visitTypeInsn(189, "io/opentelemetry/javaagent/extension/muzzle/Reference$Flag");
                        j = 0;
                        for (Reference.Flag flag : method.getFlags()) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)j);
                            enumClassName = this.getEnumClassInternalName(flag);
                            mv.visitFieldInsn(178, enumClassName, flag.name(), "L" + enumClassName + ";");
                            mv.visitInsn(83);
                            ++j;
                        }
                        mv.visitLdcInsn((Object)method.getName());
                        mv.visitLdcInsn((Object)method.getReturnType().getDescriptor());
                        mv.visitMethodInsn(184, Type.getInternalName(Type.class), "getType", Type.getMethodDescriptor((Method)Type.class.getMethod("getType", String.class)), false);
                        mv.visitLdcInsn((Object)method.getParameterTypes().size());
                        mv.visitTypeInsn(189, Type.getInternalName(Type.class));
                        j = 0;
                        for (Type parameterType : method.getParameterTypes()) {
                            mv.visitInsn(89);
                            mv.visitLdcInsn((Object)j);
                            mv.visitLdcInsn((Object)parameterType.getDescriptor());
                            mv.visitMethodInsn(184, Type.getInternalName(Type.class), "getType", Type.getMethodDescriptor((Method)Type.class.getMethod("getType", String.class)), false);
                            mv.visitInsn(83);
                            ++j;
                        }
                        mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "withMethod", Type.getMethodDescriptor((Method)Reference.Builder.class.getMethod("withMethod", Reference.Source[].class, Reference.Flag[].class, String.class, Type.class, Type[].class)), false);
                    }
                    mv.visitMethodInsn(182, "io/opentelemetry/javaagent/extension/muzzle/Reference$Builder", "build", "()Lio/opentelemetry/javaagent/extension/muzzle/Reference;", false);
                    mv.visitInsn(83);
                }
                mv.visitFieldInsn(181, this.instrumentationClassName, MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, Type.getDescriptor(Reference[].class));
                mv.visitLabel(ret);
                if (this.frames) {
                    mv.visitFrame(3, 1, null, 0, null);
                }
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.instrumentationClassName, MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, Type.getDescriptor(Reference[].class));
                mv.visitInsn(176);
                mv.visitLabel(finish);
                mv.visitLocalVariable("this", "L" + this.instrumentationClassName + ";", null, start, finish, 0);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void generateMuzzleReferencesField() {
            super.visitField(66, MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, Type.getDescriptor(Reference[].class), null, null);
        }

        private void generateMuzzleContextStoreClassesMethod(ReferenceCollector collector) {
            MethodVisitor mv = super.visitMethod(1, MuzzleCodeGenerator.MUZZLE_CONTEXT_STORE_CLASSES_METHOD_NAME, "()Ljava/util/Map;", null, null);
            mv.visitCode();
            Map<String, String> contextStoreClasses = collector.getContextStoreClasses();
            mv.visitTypeInsn(187, "java/util/HashMap");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)contextStoreClasses.size());
            mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "(I)V", false);
            mv.visitVarInsn(58, 1);
            contextStoreClasses.forEach((className, contextClassName) -> {
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(className);
                mv.visitLdcInsn(contextClassName);
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                mv.visitInsn(87);
            });
            mv.visitVarInsn(25, 1);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private String getEnumClassInternalName(Reference.Flag flag) {
            String fullInternalName = Utils.getInternalName(flag.getClass());
            Matcher m = ANONYMOUS_ENUM_CONSTANT_CLASS.matcher(fullInternalName);
            return m.matches() ? m.group("enumClass") : fullInternalName;
        }

        private class InitializeReferencesField
        extends MethodVisitor {
            public InitializeReferencesField(MethodVisitor methodVisitor) {
                super(458752, methodVisitor);
            }

            public void visitInsn(int opcode) {
                if (opcode == 177) {
                    super.visitVarInsn(25, 0);
                    super.visitInsn(1);
                    super.visitFieldInsn(181, GenerateMuzzleMethodsAndFields.this.instrumentationClassName, MuzzleCodeGenerator.MUZZLE_REFERENCES_FIELD_NAME, Type.getDescriptor(Reference[].class));
                }
                super.visitInsn(opcode);
            }
        }
    }
}

