/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.matcher.ElementMatcher;

public class LoggingFailSafeMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Logger logger = Logger.getLogger(LoggingFailSafeMatcher.class.getName());
    private final ElementMatcher<? super T> matcher;
    private final String description;

    public LoggingFailSafeMatcher(ElementMatcher<? super T> matcher, String description) {
        this.matcher = matcher;
        this.description = description;
    }

    public boolean matches(T target) {
        try {
            return this.matcher.matches(target);
        }
        catch (Throwable e) {
            logger.log(Level.FINE, this.description, e);
            return false;
        }
    }

    public String toString() {
        return "failSafe(try(" + this.matcher + ") or false)";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoggingFailSafeMatcher)) {
            return false;
        }
        LoggingFailSafeMatcher other = (LoggingFailSafeMatcher)((Object)obj);
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }
}

