/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.field.FieldAccessorInterfaces;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementations;
import io.opentelemetry.javaagent.tooling.muzzle.VirtualFieldMappings;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

final class VirtualFieldImplementationsGenerator {
    private final ByteBuddy byteBuddy;

    VirtualFieldImplementationsGenerator(ByteBuddy byteBuddy) {
        this.byteBuddy = byteBuddy;
    }

    VirtualFieldImplementations generateClasses(VirtualFieldMappings virtualFieldMappings, FieldAccessorInterfaces fieldAccessorInterfaces) {
        HashMap virtualFieldImplementations = new HashMap(virtualFieldMappings.size());
        for (Map.Entry entry : virtualFieldMappings.entrySet()) {
            DynamicType.Unloaded<?> type = this.makeVirtualFieldImplementationClass((String)entry.getKey(), (String)entry.getValue(), fieldAccessorInterfaces);
            virtualFieldImplementations.put(type.getTypeDescription().getName(), type);
        }
        return new VirtualFieldImplementations(virtualFieldImplementations);
    }

    private DynamicType.Unloaded<?> makeVirtualFieldImplementationClass(String typeName, String fieldTypeName, FieldAccessorInterfaces fieldAccessorInterfaces) {
        return this.byteBuddy.rebase(VirtualFieldImplementationTemplate.class).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, TypeManifestation.FINAL, SyntheticState.SYNTHETIC}).name(GeneratedVirtualFieldNames.getVirtualFieldImplementationClassName(typeName, fieldTypeName)).visit(this.getVirtualFieldImplementationVisitor(typeName, fieldTypeName, fieldAccessorInterfaces)).make();
    }

    private AsmVisitorWrapper getVirtualFieldImplementationVisitor(final String typeName, final String fieldTypeName, final FieldAccessorInterfaces fieldAccessorInterfaces) {
        return new AsmVisitorWrapper(){

            public int mergeWriter(int flags) {
                return flags | 1;
            }

            public int mergeReader(int flags) {
                return flags;
            }

            public ClassVisitor wrap(final TypeDescription instrumentedType, ClassVisitor classVisitor, final Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
                return new ClassVisitor(458752, classVisitor){
                    private final TypeDescription accessorInterface;
                    private final String accessorInterfaceInternalName;
                    private final String instrumentedTypeInternalName;
                    private final boolean frames;
                    {
                        super(api, classVisitor);
                        this.accessorInterface = fieldAccessorInterfaces.find(typeName, fieldTypeName);
                        this.accessorInterfaceInternalName = this.accessorInterface.getInternalName();
                        this.instrumentedTypeInternalName = instrumentedType.getInternalName();
                        this.frames = implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6);
                    }

                    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                        if ("realGet".equals(name)) {
                            this.generateRealGetMethod(name);
                            return null;
                        }
                        if ("realPut".equals(name)) {
                            this.generateRealPutMethod(name);
                            return null;
                        }
                        return super.visitMethod(access, name, descriptor, signature, exceptions);
                    }

                    private void generateRealGetMethod(String name) {
                        String getterName = GeneratedVirtualFieldNames.getRealGetterName(typeName, fieldTypeName);
                        Label elseLabel = new Label();
                        MethodVisitor mv = this.getMethodVisitor(name);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(193, this.accessorInterfaceInternalName);
                        mv.visitJumpInsn(153, elseLabel);
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(192, this.accessorInterfaceInternalName);
                        mv.visitMethodInsn(185, this.accessorInterfaceInternalName, getterName, Utils.getMethodDefinition((TypeDefinition)this.accessorInterface, getterName).getDescriptor(), true);
                        mv.visitInsn(176);
                        mv.visitLabel(elseLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitMethodInsn(183, this.instrumentedTypeInternalName, "mapGet", Utils.getMethodDefinition((TypeDefinition)instrumentedType, "mapGet").getDescriptor(), false);
                        mv.visitInsn(176);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private void generateRealPutMethod(String name) {
                        String setterName = GeneratedVirtualFieldNames.getRealSetterName(typeName, fieldTypeName);
                        Label elseLabel = new Label();
                        Label endLabel = new Label();
                        MethodVisitor mv = this.getMethodVisitor(name);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(193, this.accessorInterfaceInternalName);
                        mv.visitJumpInsn(153, elseLabel);
                        mv.visitVarInsn(25, 1);
                        mv.visitTypeInsn(192, this.accessorInterfaceInternalName);
                        mv.visitVarInsn(25, 2);
                        mv.visitMethodInsn(185, this.accessorInterfaceInternalName, setterName, Utils.getMethodDefinition((TypeDefinition)this.accessorInterface, setterName).getDescriptor(), true);
                        mv.visitJumpInsn(167, endLabel);
                        mv.visitLabel(elseLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(25, 2);
                        mv.visitMethodInsn(183, this.instrumentedTypeInternalName, "mapPut", Utils.getMethodDefinition((TypeDefinition)instrumentedType, "mapPut").getDescriptor(), false);
                        mv.visitLabel(endLabel);
                        if (this.frames) {
                            mv.visitFrame(3, 0, null, 0, null);
                        }
                        mv.visitInsn(177);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }

                    private MethodVisitor getMethodVisitor(String methodName) {
                        return this.cv.visitMethod(2, methodName, Utils.getMethodDefinition((TypeDefinition)instrumentedType, methodName).getDescriptor(), null, null);
                    }
                };
            }
        };
    }

    static final class VirtualFieldImplementationTemplate
    extends VirtualField<Object, Object> {
        private static final VirtualFieldImplementationTemplate INSTANCE = new VirtualFieldImplementationTemplate((Cache<Object, Object>)Cache.weak());
        private final Cache<Object, Object> map;

        private VirtualFieldImplementationTemplate(Cache<Object, Object> map) {
            this.map = map;
        }

        public Object get(Object object) {
            return this.realGet(object);
        }

        public void set(Object object, Object fieldValue) {
            this.realPut(object, fieldValue);
        }

        private Object realGet(Object key) {
            return null;
        }

        private void realPut(Object key, Object value) {
        }

        private Object mapGet(Object key) {
            return this.map.get(key);
        }

        private void mapPut(Object key, Object value) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        }

        public static VirtualField<?, ?> getVirtualField(Class<?> keyClass, Class<?> contextClass) {
            return INSTANCE;
        }
    }
}

