/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.extension.Ordered;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SafeServiceLoader {
    private static final Logger logger = Logger.getLogger(SafeServiceLoader.class.getName());

    public static <T> List<T> load(Class<T> serviceClass) {
        ArrayList<T> result = new ArrayList<T>();
        ServiceLoader<T> services = ServiceLoader.load(serviceClass);
        Iterator<T> iter = services.iterator();
        while (iter.hasNext()) {
            try {
                result.add(iter.next());
            }
            catch (UnsupportedClassVersionError e) {
                logger.log(Level.FINE, "Unable to load instrumentation class: {0}", e.getMessage());
            }
        }
        return result;
    }

    public static <T extends Ordered> List<T> loadOrdered(Class<T> serviceClass) {
        List<T> result = SafeServiceLoader.load(serviceClass);
        result.sort(Comparator.comparing(Ordered::order));
        return result;
    }

    private SafeServiceLoader() {
    }
}

