/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.javaagent.bootstrap.VirtualFieldInstalledMarker;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.field.FieldAccessorInterfaces;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.pool.TypePool;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

final class RealFieldInjector
implements AsmVisitorWrapper {
    private static final String INSTALLED_FIELDS_MARKER_CLASS_NAME = Utils.getInternalName(VirtualFieldInstalledMarker.class);
    private final FieldAccessorInterfaces fieldAccessorInterfaces;
    private final String typeName;
    private final String fieldTypeName;

    RealFieldInjector(FieldAccessorInterfaces fieldAccessorInterfaces, String typeName, String fieldTypeName) {
        this.fieldAccessorInterfaces = fieldAccessorInterfaces;
        this.typeName = typeName;
        this.fieldTypeName = fieldTypeName;
    }

    public int mergeWriter(int flags) {
        return flags | 1;
    }

    public int mergeReader(int flags) {
        return flags;
    }

    public ClassVisitor wrap(final TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new ClassVisitor(458752, classVisitor){
            private final TypeDescription fieldType;
            private final String fieldName;
            private final String getterMethodName;
            private final String setterMethodName;
            private final TypeDescription interfaceType;
            private boolean foundField;
            private boolean foundGetter;
            private boolean foundSetter;
            {
                super(api, classVisitor);
                this.fieldType = TypeDescription.OBJECT;
                this.fieldName = GeneratedVirtualFieldNames.getRealFieldName(RealFieldInjector.this.typeName, RealFieldInjector.this.fieldTypeName);
                this.getterMethodName = GeneratedVirtualFieldNames.getRealGetterName(RealFieldInjector.this.typeName, RealFieldInjector.this.fieldTypeName);
                this.setterMethodName = GeneratedVirtualFieldNames.getRealSetterName(RealFieldInjector.this.typeName, RealFieldInjector.this.fieldTypeName);
                this.interfaceType = RealFieldInjector.this.fieldAccessorInterfaces.find(RealFieldInjector.this.typeName, RealFieldInjector.this.fieldTypeName);
                this.foundField = false;
                this.foundGetter = false;
                this.foundSetter = false;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (interfaces == null) {
                    interfaces = new String[]{};
                }
                LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(interfaces));
                set.add(INSTALLED_FIELDS_MARKER_CLASS_NAME);
                set.add(this.interfaceType.getInternalName());
                super.visit(version, access, name, signature, superName, set.toArray(new String[0]));
            }

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                if (name.equals(this.fieldName)) {
                    this.foundField = true;
                }
                return super.visitField(access, name, descriptor, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                if (name.equals(this.getterMethodName)) {
                    this.foundGetter = true;
                }
                if (name.equals(this.setterMethodName)) {
                    this.foundSetter = true;
                }
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }

            public void visitEnd() {
                if (!this.foundField) {
                    this.cv.visitField(4290, this.fieldName, this.fieldType.getDescriptor(), null, null);
                }
                if (!this.foundGetter) {
                    this.addGetter();
                }
                if (!this.foundSetter) {
                    this.addSetter();
                }
                super.visitEnd();
            }

            private void addGetter() {
                MethodVisitor mv = this.getAccessorMethodVisitor(this.getterMethodName);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, instrumentedType.getInternalName(), this.fieldName, this.fieldType.getDescriptor());
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }

            private void addSetter() {
                MethodVisitor mv = this.getAccessorMethodVisitor(this.setterMethodName);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitFieldInsn(181, instrumentedType.getInternalName(), this.fieldName, this.fieldType.getDescriptor());
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }

            private MethodVisitor getAccessorMethodVisitor(String methodName) {
                return this.cv.visitMethod(4097, methodName, Utils.getMethodDefinition((TypeDefinition)this.interfaceType, methodName).getDescriptor(), null, null);
            }
        };
    }
}

