/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.field;

import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.instrumentation.api.internal.RuntimeVirtualFieldSupplier;
import io.opentelemetry.javaagent.tooling.field.GeneratedVirtualFieldNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class RuntimeFieldBasedImplementationSupplier
implements RuntimeVirtualFieldSupplier.VirtualFieldSupplier {
    RuntimeFieldBasedImplementationSupplier() {
    }

    public <U extends T, V extends F, T, F> VirtualField<U, V> find(Class<T> type, Class<F> fieldType) {
        try {
            String virtualFieldImplClassName = GeneratedVirtualFieldNames.getVirtualFieldImplementationClassName(type.getName(), fieldType.getName());
            Class<?> contextStoreClass = Class.forName(virtualFieldImplClassName, false, null);
            Method method = contextStoreClass.getMethod("getVirtualField", Class.class, Class.class);
            VirtualField field = (VirtualField)method.invoke(null, type, fieldType);
            return field;
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalStateException("VirtualField not found", exception);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new IllegalStateException("Failed to get VirtualField", exception);
        }
    }
}

