/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.tooling.AddThreadDetailsSpanProcessor;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SdkTracerProviderConfigurer.class})
public class AgentTracerProviderConfigurer
implements SdkTracerProviderConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(AgentTracerProviderConfigurer.class);
    private static final String ADD_THREAD_DETAILS = "otel.javaagent.add-thread-details";

    public void configure(SdkTracerProviderBuilder sdkTracerProviderBuilder, ConfigProperties config) {
        if (!Config.get().getBoolean("otel.javaagent.enabled", true)) {
            return;
        }
        if (Config.get().getBoolean(ADD_THREAD_DETAILS, true)) {
            sdkTracerProviderBuilder.addSpanProcessor((SpanProcessor)new AddThreadDetailsSpanProcessor());
        }
        AgentTracerProviderConfigurer.maybeEnableLoggingExporter(sdkTracerProviderBuilder);
    }

    private static void maybeEnableLoggingExporter(SdkTracerProviderBuilder builder) {
        if (Config.get().isAgentDebugEnabled() && AgentTracerProviderConfigurer.loggingExporterIsNotAlreadyConfigured()) {
            builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create()));
        }
    }

    private static boolean loggingExporterIsNotAlreadyConfigured() {
        return !Config.get().getString("otel.traces.exporter", "").equalsIgnoreCase("logging");
    }
}

