/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle;

import io.opentelemetry.javaagent.tooling.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.bytebuddy.jar.asm.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Reference {
    private final Set<Source> sources;
    private final String className;
    private final String superName;
    private final Set<Flag> flags;
    private final Set<String> interfaces;
    private final Set<Field> fields;
    private final Set<Method> methods;

    private Reference(Set<Source> sources, Set<Flag> flags, String className, String superName, Set<String> interfaces, Set<Field> fields, Set<Method> methods) {
        this.sources = sources;
        this.flags = flags;
        this.className = Utils.getClassName(className);
        this.superName = null == superName ? null : Utils.getClassName(superName);
        this.interfaces = interfaces;
        this.methods = methods;
        this.fields = fields;
    }

    public String getClassName() {
        return this.className;
    }

    public @Nullable String getSuperName() {
        return this.superName;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public Set<Method> getMethods() {
        return this.methods;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    public Reference merge(Reference anotherReference) {
        if (!anotherReference.getClassName().equals(this.className)) {
            throw new IllegalStateException("illegal merge " + this + " != " + anotherReference);
        }
        String superName = null == this.superName ? anotherReference.superName : this.superName;
        return new Reference(Reference.merge(this.sources, anotherReference.sources), Reference.mergeFlags(this.flags, anotherReference.flags), this.className, superName, Reference.merge(this.interfaces, anotherReference.interfaces), Reference.mergeFields(this.fields, anotherReference.fields), Reference.mergeMethods(this.methods, anotherReference.methods));
    }

    private static <T> Set<T> merge(Set<T> set1, Set<T> set2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    private static Set<Method> mergeMethods(Set<Method> methods1, Set<Method> methods2) {
        ArrayList<Method> merged = new ArrayList<Method>(methods1);
        for (Method method : methods2) {
            int i = merged.indexOf(method);
            if (i == -1) {
                merged.add(method);
                continue;
            }
            merged.set(i, ((Method)merged.get(i)).merge(method));
        }
        return new LinkedHashSet<Method>(merged);
    }

    private static Set<Field> mergeFields(Set<Field> fields1, Set<Field> fields2) {
        ArrayList<Field> merged = new ArrayList<Field>(fields1);
        for (Field field : fields2) {
            int i = merged.indexOf(field);
            if (i == -1) {
                merged.add(field);
                continue;
            }
            merged.set(i, ((Field)merged.get(i)).merge(field));
        }
        return new LinkedHashSet<Field>(merged);
    }

    private static Set<Flag> mergeFlags(Set<Flag> flags1, Set<Flag> flags2) {
        Set<Flag> merged = Reference.merge(flags1, flags2);
        return merged;
    }

    public String toString() {
        return "Reference<" + this.className + ">";
    }

    public static class Builder {
        private final Set<Source> sources = new LinkedHashSet<Source>();
        private final Set<Flag> flags = new LinkedHashSet<Flag>();
        private final String className;
        private String superName = null;
        private final Set<String> interfaces = new LinkedHashSet<String>();
        private final List<Field> fields = new ArrayList<Field>();
        private final List<Method> methods = new ArrayList<Method>();

        public Builder(String className) {
            this.className = className;
        }

        public Builder withSuperName(String superName) {
            this.superName = superName;
            return this;
        }

        public Builder withInterfaces(Collection<String> interfaceNames) {
            this.interfaces.addAll(interfaceNames);
            return this;
        }

        public Builder withInterface(String interfaceName) {
            this.interfaces.add(interfaceName);
            return this;
        }

        public Builder withSource(String sourceName) {
            return this.withSource(sourceName, 0);
        }

        public Builder withSource(String sourceName, int line) {
            this.sources.add(new Source(sourceName, line));
            return this;
        }

        public Builder withFlag(Flag flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder withField(Source[] sources, Flag[] fieldFlags, String fieldName, Type fieldType) {
            Field field = new Field(sources, fieldFlags, fieldName, fieldType);
            int existingIndex = this.fields.indexOf(field);
            if (existingIndex == -1) {
                this.fields.add(field);
            } else {
                this.fields.set(existingIndex, field.merge(this.fields.get(existingIndex)));
            }
            return this;
        }

        public Builder withMethod(Source[] sources, Flag[] methodFlags, String methodName, Type returnType, Type ... methodArgs) {
            Method method = new Method(sources, methodFlags, methodName, returnType, methodArgs);
            int existingIndex = this.methods.indexOf(method);
            if (existingIndex == -1) {
                this.methods.add(method);
            } else {
                this.methods.set(existingIndex, method.merge(this.methods.get(existingIndex)));
            }
            return this;
        }

        public Reference build() {
            return new Reference(this.sources, this.flags, this.className, this.superName, this.interfaces, new LinkedHashSet<Field>(this.fields), new LinkedHashSet<Method>(this.methods));
        }
    }

    public static class Field {
        private final Set<Source> sources;
        private final Set<Flag> flags;
        private final String name;
        private final Type type;

        public Field(Source[] sources, Flag[] flags, String name, Type fieldType) {
            this.sources = new LinkedHashSet<Source>(Arrays.asList(sources));
            this.flags = new LinkedHashSet<Flag>(Arrays.asList(flags));
            this.name = name;
            this.type = fieldType;
        }

        public String getName() {
            return this.name;
        }

        public Set<Source> getSources() {
            return this.sources;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public Type getType() {
            return this.type;
        }

        public Field merge(Field anotherField) {
            if (!this.equals(anotherField) || !this.type.equals((Object)anotherField.type)) {
                throw new IllegalStateException("illegal merge " + this + " != " + anotherField);
            }
            return new Field(Reference.merge(this.sources, anotherField.sources).toArray(new Source[0]), Reference.mergeFlags(this.flags, anotherField.flags).toArray(new Flag[0]), this.name, this.type);
        }

        public String toString() {
            return "FieldRef:" + this.name + this.type.getInternalName();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Field)) {
                return false;
            }
            Field other = (Field)obj;
            return this.name.equals(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class Method {
        private final Set<Source> sources;
        private final Set<Flag> flags;
        private final String name;
        private final Type returnType;
        private final List<Type> parameterTypes;

        public Method(String name, String descriptor) {
            this(new Source[0], new Flag[0], name, Type.getMethodType((String)descriptor).getReturnType(), Type.getMethodType((String)descriptor).getArgumentTypes());
        }

        public Method(Source[] sources, Flag[] flags, String name, Type returnType, Type[] parameterTypes) {
            this(new LinkedHashSet<Source>(Arrays.asList(sources)), new LinkedHashSet<Flag>(Arrays.asList(flags)), name, returnType, Arrays.asList(parameterTypes));
        }

        private Method(Set<Source> sources, Set<Flag> flags, String name, Type returnType, List<Type> parameterTypes) {
            this.sources = sources;
            this.flags = flags;
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public Set<Source> getSources() {
            return this.sources;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public String getName() {
            return this.name;
        }

        public Type getReturnType() {
            return this.returnType;
        }

        public List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        public Method merge(Method anotherMethod) {
            if (!this.equals(anotherMethod)) {
                throw new IllegalStateException("illegal merge " + this + " != " + anotherMethod);
            }
            LinkedHashSet<Source> mergedSources = new LinkedHashSet<Source>();
            mergedSources.addAll(this.sources);
            mergedSources.addAll(anotherMethod.sources);
            LinkedHashSet<Flag> mergedFlags = new LinkedHashSet<Flag>();
            mergedFlags.addAll(this.flags);
            mergedFlags.addAll(anotherMethod.flags);
            return new Method(mergedSources, mergedFlags, this.name, this.returnType, this.parameterTypes);
        }

        public String toString() {
            return this.name + this.getDescriptor();
        }

        public String getDescriptor() {
            return Type.getMethodType((Type)this.returnType, (Type[])this.parameterTypes.toArray(new Type[0])).getDescriptor();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Method)) {
                return false;
            }
            Method other = (Method)obj;
            return this.name.equals(other.name) && this.getDescriptor().equals(other.getDescriptor());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.getDescriptor());
        }
    }

    public static interface Flag {
        public boolean matches(int var1);

        public String name();

        public static enum OwnershipFlag implements Flag
        {
            STATIC{

                @Override
                public boolean matches(int asmFlags) {
                    return (8 & asmFlags) != 0;
                }
            }
            ,
            NON_STATIC{

                @Override
                public boolean matches(int asmFlags) {
                    return !STATIC.matches(asmFlags);
                }
            };

        }

        public static enum ManifestationFlag implements Flag
        {
            FINAL{

                @Override
                public boolean matches(int asmFlags) {
                    return (0x10 & asmFlags) != 0;
                }
            }
            ,
            NON_FINAL{

                @Override
                public boolean matches(int asmFlags) {
                    return !ABSTRACT.matches(asmFlags) && !FINAL.matches(asmFlags);
                }
            }
            ,
            ABSTRACT{

                @Override
                public boolean matches(int asmFlags) {
                    return (0x400 & asmFlags) != 0;
                }
            }
            ,
            INTERFACE{

                @Override
                public boolean matches(int asmFlags) {
                    return (0x200 & asmFlags) != 0;
                }
            }
            ,
            NON_INTERFACE{

                @Override
                public boolean matches(int asmFlags) {
                    return !INTERFACE.matches(asmFlags);
                }
            };

        }

        public static enum MinimumVisibilityFlag implements Flag
        {
            PUBLIC{

                @Override
                public boolean matches(int asmFlags) {
                    return VisibilityFlag.PUBLIC.matches(asmFlags);
                }
            }
            ,
            PROTECTED_OR_HIGHER{

                @Override
                public boolean matches(int asmFlags) {
                    return VisibilityFlag.PUBLIC.matches(asmFlags) || VisibilityFlag.PROTECTED.matches(asmFlags);
                }
            }
            ,
            PACKAGE_OR_HIGHER{

                @Override
                public boolean matches(int asmFlags) {
                    return !VisibilityFlag.PRIVATE.matches(asmFlags);
                }
            }
            ,
            PRIVATE_OR_HIGHER{

                @Override
                public boolean matches(int asmFlags) {
                    return true;
                }
            };

        }

        public static enum VisibilityFlag implements Flag
        {
            PUBLIC{

                @Override
                public boolean matches(int asmFlags) {
                    return (1 & asmFlags) != 0;
                }
            }
            ,
            PROTECTED{

                @Override
                public boolean matches(int asmFlags) {
                    return (4 & asmFlags) != 0;
                }
            }
            ,
            PACKAGE{

                @Override
                public boolean matches(int asmFlags) {
                    return !PUBLIC.matches(asmFlags) && !PROTECTED.matches(asmFlags) && !PRIVATE.matches(asmFlags);
                }
            }
            ,
            PRIVATE{

                @Override
                public boolean matches(int asmFlags) {
                    return (2 & asmFlags) != 0;
                }
            };

        }
    }

    public static class Source {
        private final String name;
        private final int line;

        public Source(String name, int line) {
            this.name = name;
            this.line = line;
        }

        public String toString() {
            return this.getName() + ":" + this.getLine();
        }

        public String getName() {
            return this.name;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Source)) {
                return false;
            }
            Source other = (Source)obj;
            return this.name.equals(other.name) && this.line == other.line;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.line);
        }
    }
}

