/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import io.opentelemetry.javaagent.instrumentation.api.WeakMap;
import io.opentelemetry.javaagent.tooling.CommonTaskExecutor;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class WeakMapSuppliers {
    WeakMapSuppliers() {
    }

    static class Guava
    implements WeakMap.Implementation {
        Guava() {
        }

        public <K, V> WeakMap<K, V> get() {
            return new WeakMap.MapAdapter((Map)new MapMaker().weakKeys().makeMap());
        }

        public <K, V> WeakMap<K, V> get(int concurrencyLevel) {
            return new WeakMap.MapAdapter((Map)new MapMaker().concurrencyLevel(concurrencyLevel).weakKeys().makeMap());
        }
    }

    static class WeakConcurrent
    implements WeakMap.Implementation {
        @VisibleForTesting
        static final long CLEAN_FREQUENCY_SECONDS = 1L;

        WeakConcurrent() {
        }

        public <K, V> WeakMap<K, V> get() {
            WeakConcurrentMap map = new WeakConcurrentMap(false, true);
            CommonTaskExecutor.INSTANCE.scheduleAtFixedRate(MapCleaningTask.INSTANCE, map, 1L, 1L, TimeUnit.SECONDS, "cleaner for " + map);
            return new Adapter(map);
        }

        static class Inline
        implements WeakMap.Implementation {
            Inline() {
            }

            public <K, V> WeakMap<K, V> get() {
                return new Adapter((WeakConcurrentMap)new WeakConcurrentMap.WithInlinedExpunction());
            }
        }

        private static class Adapter<K, V>
        implements WeakMap<K, V> {
            private final WeakConcurrentMap<K, V> map;

            private Adapter(WeakConcurrentMap<K, V> map) {
                this.map = map;
            }

            public int size() {
                return this.map.approximateSize();
            }

            public boolean containsKey(K key) {
                return this.map.containsKey(key);
            }

            public V get(K key) {
                return (V)this.map.get(key);
            }

            public void put(K key, V value) {
                this.map.put(key, value);
            }

            public void putIfAbsent(K key, V value) {
                this.map.putIfAbsent(key, value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public V computeIfAbsent(K key, WeakMap.ValueSupplier<? super K, ? extends V> supplier) {
                if (this.map.containsKey(key)) {
                    return (V)this.map.get(key);
                }
                Adapter adapter = this;
                synchronized (adapter) {
                    if (this.map.containsKey(key)) {
                        return (V)this.map.get(key);
                    }
                    Object value = supplier.get(key);
                    this.map.put(key, value);
                    return (V)value;
                }
            }

            public V remove(K key) {
                return (V)this.map.remove(key);
            }
        }

        private static class MapCleaningTask
        implements CommonTaskExecutor.Task<WeakConcurrentMap> {
            static final MapCleaningTask INSTANCE = new MapCleaningTask();

            private MapCleaningTask() {
            }

            @Override
            public void run(WeakConcurrentMap target) {
                target.expungeStaleEntries();
            }
        }
    }
}

