/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.AwsXrayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.JaegerPropagator;
import io.opentelemetry.extension.trace.propagation.OtTracerPropagator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagatorsInitializer {
    private static final Logger log = LoggerFactory.getLogger(PropagatorsInitializer.class);
    private static final Map<String, Propagator> TEXTMAP_PROPAGATORS;

    public static ContextPropagators initializePropagators(List<String> propagatorIds) {
        return PropagatorsInitializer.initializePropagators(propagatorIds, () -> GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator());
    }

    static ContextPropagators initializePropagators(List<String> propagatorIds, Supplier<TextMapPropagator> preconfiguredPropagator) {
        return PropagatorsInitializer.createPropagators(propagatorIds, preconfiguredPropagator.get());
    }

    private static ContextPropagators createPropagators(List<String> propagatorIds, TextMapPropagator preconfiguredPropagator) {
        if (propagatorIds.size() == 0) {
            return PropagatorsInitializer.createPropagatorsRemovingNoops(Arrays.asList(preconfiguredPropagator, W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()));
        }
        ArrayList<TextMapPropagator> textMapPropagators = new ArrayList<TextMapPropagator>();
        textMapPropagators.add(preconfiguredPropagator);
        for (String propagatorId : propagatorIds) {
            Propagator propagator = TEXTMAP_PROPAGATORS.get(propagatorId);
            if (propagator != null) {
                textMapPropagators.add(propagator);
                log.info("Added " + propagatorId + " propagator");
                continue;
            }
            log.warn("No matching propagator for " + propagatorId);
        }
        return PropagatorsInitializer.createPropagatorsRemovingNoops(textMapPropagators);
    }

    private static ContextPropagators createPropagatorsRemovingNoops(List<TextMapPropagator> textMapPropagators) {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((Iterable)textMapPropagators.stream().filter(propagator -> propagator != TextMapPropagator.noop()).collect(Collectors.toSet())));
    }

    static {
        ImmutableMap.Builder propagators = ImmutableMap.builder();
        for (Propagator propagator : Propagator.values()) {
            propagators.put((Object)propagator.id(), (Object)propagator);
        }
        TEXTMAP_PROPAGATORS = propagators.build();
    }

    static enum Propagator implements TextMapPropagator
    {
        BAGGAGE("baggage", (TextMapPropagator)W3CBaggagePropagator.getInstance(), true),
        JAEGER("jaeger", (TextMapPropagator)JaegerPropagator.getInstance(), true),
        B3("b3", (TextMapPropagator)B3Propagator.getInstance(), false),
        B3_MULTI("b3multi", (TextMapPropagator)B3Propagator.builder().injectMultipleHeaders().build(), false),
        OT_TRACER("ottracer", (TextMapPropagator)OtTracerPropagator.getInstance(), false),
        TRACE_CONTEXT("tracecontext", W3CTraceContextPropagator.getInstance(), false),
        XRAY("xray", (TextMapPropagator)AwsXrayPropagator.getInstance(), false);

        private final String id;
        private final TextMapPropagator delegate;
        private final boolean alwaysRun;

        private Propagator(String id, TextMapPropagator delegate, boolean alwaysRun) {
            this.id = id;
            this.delegate = delegate;
            this.alwaysRun = alwaysRun;
        }

        String id() {
            return this.id;
        }

        boolean alwaysRun() {
            return this.alwaysRun;
        }

        public Collection<String> fields() {
            return this.delegate.fields();
        }

        public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
            this.delegate.inject(context, carrier, setter);
        }

        public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
            return this.delegate.extract(context, carrier, getter);
        }
    }
}

