/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.AwsXRayPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.JaegerPropagator;
import io.opentelemetry.extension.trace.propagation.OtTracerPropagator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagatorsInitializer {
    private static final Logger log = LoggerFactory.getLogger(PropagatorsInitializer.class);
    private static final Map<String, Propagator> TEXTMAP_PROPAGATORS;

    public static void initializePropagators(List<String> propagatorIds) {
        if (propagatorIds.size() == 0) {
            OpenTelemetry.setGlobalPropagators((ContextPropagators)ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()})));
            return;
        }
        ArrayList<Propagator> propagators = new ArrayList<Propagator>(propagatorIds.size());
        ArrayList<TextMapPropagator> textMapPropagators = new ArrayList<TextMapPropagator>();
        for (String propagatorId : propagatorIds) {
            Propagator propagator = TEXTMAP_PROPAGATORS.get(propagatorId);
            if (propagator != null) {
                propagators.add(propagator);
                log.info("Added " + propagatorId + " propagator");
                continue;
            }
            log.warn("No matching propagator for " + propagatorId);
        }
        if (propagators.size() > 1) {
            textMapPropagators.add(new MultiPropagator(propagators));
        } else if (propagators.size() == 1) {
            textMapPropagators.add((TextMapPropagator)propagators.get(0));
        }
        OpenTelemetry.setGlobalPropagators((ContextPropagators)ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators)));
    }

    private static TracerProvider unobfuscate(TracerProvider tracerProvider) {
        if (tracerProvider.getClass().getName().endsWith("TracerSdkProvider")) {
            return tracerProvider;
        }
        try {
            Method unobfuscate = tracerProvider.getClass().getDeclaredMethod("unobfuscate", new Class[0]);
            unobfuscate.setAccessible(true);
            return (TracerProvider)unobfuscate.invoke((Object)tracerProvider, new Object[0]);
        }
        catch (Throwable t) {
            return tracerProvider;
        }
    }

    static {
        ImmutableMap.Builder propagators = ImmutableMap.builder();
        for (Propagator propagator : Propagator.values()) {
            propagators.put((Object)propagator.id(), (Object)propagator);
        }
        TEXTMAP_PROPAGATORS = propagators.build();
    }

    static enum Propagator implements TextMapPropagator
    {
        BAGGAGE("baggage", (TextMapPropagator)W3CBaggagePropagator.getInstance(), true),
        JAEGER("jaeger", (TextMapPropagator)JaegerPropagator.getInstance(), true),
        B3("b3", (TextMapPropagator)B3Propagator.getInstance(), false),
        B3_MULTI("b3multi", (TextMapPropagator)B3Propagator.builder().injectMultipleHeaders().build(), false),
        OT_TRACER("ottracer", (TextMapPropagator)OtTracerPropagator.getInstance(), false),
        TRACE_CONTEXT("tracecontext", W3CTraceContextPropagator.getInstance(), false),
        XRAY("xray", (TextMapPropagator)AwsXRayPropagator.getInstance(), false);

        private final String id;
        private final TextMapPropagator delegate;
        private final boolean alwaysRun;

        private Propagator(String id, TextMapPropagator delegate, boolean alwaysRun) {
            this.id = id;
            this.delegate = delegate;
            this.alwaysRun = alwaysRun;
        }

        String id() {
            return this.id;
        }

        boolean alwaysRun() {
            return this.alwaysRun;
        }

        public Collection<String> fields() {
            return this.delegate.fields();
        }

        public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
            this.delegate.inject(context, carrier, setter);
        }

        public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
            return this.delegate.extract(context, carrier, getter);
        }
    }

    static class MultiPropagator
    implements TextMapPropagator {
        private final List<Propagator> propagators;
        private final List<String> fields;

        private MultiPropagator(List<Propagator> propagators) {
            this.propagators = propagators;
            LinkedHashSet fields = new LinkedHashSet();
            for (Propagator propagator : propagators) {
                fields.addAll(propagator.delegate.fields());
            }
            this.fields = new ArrayList<String>(fields);
        }

        public List<String> fields() {
            return this.fields;
        }

        public <C> void inject(Context context, C carrier, TextMapPropagator.Setter<C> setter) {
            for (Propagator propagator : this.propagators) {
                propagator.inject(context, carrier, setter);
            }
        }

        public <C> Context extract(Context context, C carrier, TextMapPropagator.Getter<C> getter) {
            boolean spanContextExtracted = false;
            for (int i = this.propagators.size() - 1; i >= 0; --i) {
                Propagator propagator = this.propagators.get(i);
                if (!propagator.alwaysRun() && spanContextExtracted) continue;
                context = propagator.extract(context, carrier, getter);
                if (spanContextExtracted) continue;
                spanContextExtracted = MultiPropagator.isSpanContextExtracted(context);
            }
            return context;
        }

        private static boolean isSpanContextExtracted(Context context) {
            return Span.fromContextOrNull((Context)context) != null;
        }
    }
}

