/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.javaagent.spi.ComponentInstaller;
import io.opentelemetry.javaagent.spi.TracerCustomizer;
import io.opentelemetry.javaagent.spi.exporter.MetricExporterFactory;
import io.opentelemetry.javaagent.spi.exporter.MetricServer;
import io.opentelemetry.javaagent.spi.exporter.SpanExporterFactory;
import io.opentelemetry.javaagent.tooling.AddThreadDetailsSpanProcessor;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import io.opentelemetry.javaagent.tooling.ExporterClassLoader;
import io.opentelemetry.javaagent.tooling.PropagatorsInitializer;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryInstaller
implements ComponentInstaller {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryInstaller.class);
    private static final String EXPORTER_JAR_CONFIG = "otel.exporter.jar";
    private static final String EXPORTERS_CONFIG = "otel.exporter";
    private static final String PROPAGATORS_CONFIG = "otel.propagators";
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final List<String> DEFAULT_EXPORTERS = Collections.singletonList("otlp");

    public void beforeByteBuddyAgent() {
        OpenTelemetry.getGlobalTracerProvider();
        OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> OpenTelemetrySdk.getGlobalTracerManagement().forceFlush().join((long)timeout, unit));
    }

    public void afterByteBuddyAgent() {
        OpenTelemetryInstaller.installAgentTracer();
    }

    public static synchronized void installAgentTracer() {
        if (Config.get().getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            Properties config = Config.get().asJavaProperties();
            OpenTelemetryInstaller.configure(config);
            String exporterJar = Config.get().getProperty(EXPORTER_JAR_CONFIG);
            if (exporterJar != null) {
                OpenTelemetryInstaller.installExportersFromJar(exporterJar, config);
            } else {
                OpenTelemetryInstaller.installExporters(Config.get().getListProperty(EXPORTERS_CONFIG, DEFAULT_EXPORTERS), config);
            }
        } else {
            log.info("Tracing is disabled.");
        }
        PropagatorsInitializer.initializePropagators(Config.get().getListProperty(PROPAGATORS_CONFIG));
    }

    private static synchronized void installExporters(List<String> exporters, Properties config) {
        for (String exporterName : exporters) {
            SpanExporterFactory spanExporterFactory = OpenTelemetryInstaller.findSpanExporterFactory(exporterName);
            if (spanExporterFactory != null) {
                OpenTelemetryInstaller.installExporter(spanExporterFactory, config);
            } else {
                log.warn("No {} span exporter found", (Object)exporterName);
            }
            MetricExporterFactory metricExporterFactory = OpenTelemetryInstaller.findMetricExporterFactory(exporterName);
            if (metricExporterFactory != null) {
                OpenTelemetryInstaller.installExporter(metricExporterFactory, config);
            } else {
                log.debug("No {} metric exporter found", (Object)exporterName);
            }
            MetricServer metricServer = OpenTelemetryInstaller.findMetricServer(exporterName);
            if (metricServer != null) {
                OpenTelemetryInstaller.installMetricServer(metricServer, config);
                continue;
            }
            log.debug("No {} metric server found", (Object)exporterName);
        }
    }

    private static MetricExporterFactory findMetricExporterFactory(String exporterName) {
        ServiceLoader<MetricExporterFactory> serviceLoader = ServiceLoader.load(MetricExporterFactory.class, OpenTelemetryInstaller.class.getClassLoader());
        for (MetricExporterFactory metricExporterFactory : serviceLoader) {
            if (!metricExporterFactory.getNames().contains(exporterName)) continue;
            return metricExporterFactory;
        }
        return null;
    }

    private static MetricServer findMetricServer(String exporterName) {
        ServiceLoader<MetricServer> serviceLoader = ServiceLoader.load(MetricServer.class, OpenTelemetryInstaller.class.getClassLoader());
        for (MetricServer metricServer : serviceLoader) {
            if (!metricServer.getNames().contains(exporterName)) continue;
            return metricServer;
        }
        return null;
    }

    private static SpanExporterFactory findSpanExporterFactory(String exporterName) {
        ServiceLoader<SpanExporterFactory> serviceLoader = ServiceLoader.load(SpanExporterFactory.class, OpenTelemetryInstaller.class.getClassLoader());
        for (SpanExporterFactory spanExporterFactory : serviceLoader) {
            if (!spanExporterFactory.getNames().contains(exporterName)) continue;
            return spanExporterFactory;
        }
        return null;
    }

    private static synchronized void installExportersFromJar(String exporterJar, Properties config) {
        URL url;
        try {
            url = new File(exporterJar).toURI().toURL();
        }
        catch (MalformedURLException e) {
            log.warn("Filename could not be parsed: " + exporterJar + ". Exporter is not installed");
            log.warn("No valid exporter found. Tracing will run but spans are dropped");
            return;
        }
        ExporterClassLoader exporterLoader = new ExporterClassLoader(url, OpenTelemetryInstaller.class.getClassLoader());
        SpanExporterFactory spanExporterFactory = OpenTelemetryInstaller.getExporterFactory(SpanExporterFactory.class, exporterLoader);
        if (spanExporterFactory != null) {
            OpenTelemetryInstaller.installExporter(spanExporterFactory, config);
        } else {
            log.warn("No span exporter found in {}", (Object)exporterJar);
            log.warn("No valid exporter found. Tracing will run but spans are dropped");
        }
        MetricExporterFactory metricExporterFactory = OpenTelemetryInstaller.getExporterFactory(MetricExporterFactory.class, exporterLoader);
        if (metricExporterFactory != null) {
            OpenTelemetryInstaller.installExporter(metricExporterFactory, config);
        }
    }

    private static void installExporter(MetricExporterFactory metricExporterFactory, Properties config) {
        MetricExporter metricExporter = metricExporterFactory.fromConfig(config);
        ((IntervalMetricReader.Builder)IntervalMetricReader.builder().readProperties(config)).setMetricExporter(metricExporter).setMetricProducers(Collections.singleton(OpenTelemetrySdk.getGlobalMeterProvider().getMetricProducer())).build();
        log.info("Installed metric exporter: " + metricExporter.getClass().getName());
    }

    private static void installExporter(SpanExporterFactory spanExporterFactory, Properties config) {
        SpanExporter spanExporter = spanExporterFactory.fromConfig(config);
        BatchSpanProcessor spanProcessor = ((BatchSpanProcessorBuilder)BatchSpanProcessor.builder((SpanExporter)spanExporter).readProperties(config)).build();
        OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor((SpanProcessor)spanProcessor);
        log.info("Installed span exporter: " + spanExporter.getClass().getName());
    }

    private static void installMetricServer(MetricServer metricServer, Properties config) {
        MetricProducer metricProducer = OpenTelemetrySdk.getGlobalMeterProvider().getMetricProducer();
        metricServer.start(metricProducer, config);
        log.info("Installed metric server: " + metricServer.getClass().getName());
    }

    private static <F> F getExporterFactory(Class<F> service, ExporterClassLoader exporterLoader) {
        ServiceLoader<F> serviceLoader = ServiceLoader.load(service, exporterLoader);
        Iterator<F> i = serviceLoader.iterator();
        if (i.hasNext()) {
            F factory = i.next();
            if (i.hasNext()) {
                log.warn("Exporter JAR defines more than one {}. Only the first one found will be used", (Object)service.getName());
            }
            return factory;
        }
        return null;
    }

    private static void configure(Properties config) {
        SdkTracerManagement tracerManagement = OpenTelemetrySdk.getGlobalTracerManagement();
        tracerManagement.addSpanProcessor((SpanProcessor)new AddThreadDetailsSpanProcessor());
        ServiceLoader<TracerCustomizer> serviceLoader = ServiceLoader.load(TracerCustomizer.class, OpenTelemetryInstaller.class.getClassLoader());
        for (TracerCustomizer customizer : serviceLoader) {
            customizer.configure(tracerManagement);
        }
        TraceConfig activeTraceConfig = tracerManagement.getActiveTraceConfig();
        tracerManagement.updateActiveTraceConfig(activeTraceConfig.toBuilder().readProperties(config).build());
    }

    public static void logVersionInfo() {
        VersionLogger.logAllVersions();
        log.debug(AgentInstaller.class.getName() + " loaded on " + AgentInstaller.class.getClassLoader());
    }
}

