/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.bootstrap.WeakCache;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderMatcher {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderMatcher.class);
    public static final ClassLoader BOOTSTRAP_CLASSLOADER = null;

    private ClassLoaderMatcher() {
        throw new UnsupportedOperationException();
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> skipClassLoader() {
        return SkipClassLoaderMatcher.INSTANCE;
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> hasClassesNamed(String ... classNames) {
        return new ClassLoaderHasClassesNamedMatcher(classNames);
    }

    private static class ClassLoaderHasClassesNamedMatcher
    extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
        private final WeakCache<ClassLoader, Boolean> cache = AgentTooling.newWeakCache(25L);
        private final String[] resources;

        private ClassLoaderHasClassesNamedMatcher(String ... classNames) {
            this.resources = classNames;
            for (int i = 0; i < this.resources.length; ++i) {
                this.resources[i] = this.resources[i].replace(".", "/") + ".class";
            }
        }

        private boolean hasResources(ClassLoader cl) {
            for (String resource : this.resources) {
                if (cl.getResource(resource) != null) continue;
                return false;
            }
            return true;
        }

        public boolean matches(ClassLoader cl) {
            if (cl == BOOTSTRAP_CLASSLOADER) {
                return false;
            }
            Boolean cached = (Boolean)this.cache.getIfPresent((Object)cl);
            if (cached != null) {
                return cached;
            }
            boolean value = this.hasResources(cl);
            this.cache.put((Object)cl, (Object)value);
            return value;
        }
    }

    private static class SkipClassLoaderMatcher
    extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
        public static final SkipClassLoaderMatcher INSTANCE = new SkipClassLoaderMatcher();
        private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
        private static final String EXPORTER_CLASSLOADER_NAME = "io.opentelemetry.javaagent.tooling.ExporterClassLoader";
        private static final WeakCache<ClassLoader, Boolean> skipCache = AgentTooling.newWeakCache();

        private SkipClassLoaderMatcher() {
        }

        public boolean matches(ClassLoader cl) {
            if (cl == BOOTSTRAP_CLASSLOADER) {
                return false;
            }
            if (SkipClassLoaderMatcher.canSkipClassLoaderByName(cl)) {
                return true;
            }
            Boolean v = (Boolean)skipCache.getIfPresent((Object)cl);
            if (v != null) {
                return v;
            }
            v = !SkipClassLoaderMatcher.delegatesToBootstrap(cl);
            skipCache.put((Object)cl, (Object)v);
            return v;
        }

        private static boolean canSkipClassLoaderByName(ClassLoader loader) {
            switch (loader.getClass().getName()) {
                case "org.codehaus.groovy.runtime.callsite.CallSiteClassLoader": 
                case "sun.reflect.DelegatingClassLoader": 
                case "jdk.internal.reflect.DelegatingClassLoader": 
                case "clojure.lang.DynamicClassLoader": 
                case "org.apache.cxf.common.util.ASMHelper$TypeHelperClassLoader": 
                case "sun.misc.Launcher$ExtClassLoader": 
                case "io.opentelemetry.javaagent.bootstrap.AgentClassLoader": 
                case "io.opentelemetry.javaagent.tooling.ExporterClassLoader": {
                    return true;
                }
            }
            return false;
        }

        private static boolean delegatesToBootstrap(ClassLoader loader) {
            boolean delegates = true;
            if (!SkipClassLoaderMatcher.loadsExpectedClass(loader, PatchLogger.class)) {
                log.debug("loader {} failed to delegate bootstrap agent class", (Object)loader);
                delegates = false;
            }
            return delegates;
        }

        private static boolean loadsExpectedClass(ClassLoader loader, Class<?> expectedClass) {
            try {
                return loader.loadClass(expectedClass.getName()) == expectedClass;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
}

