/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentStarter;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public final class AgentInitializer {
    @Nullable
    private static ClassLoader agentClassLoader = null;
    @Nullable
    private static AgentStarter agentStarter = null;

    public static void initialize(Instrumentation inst, File javaagentFile, boolean fromPremain) throws Exception {
        if (agentClassLoader != null) {
            return;
        }
        agentClassLoader = AgentInitializer.createAgentClassLoader("inst", javaagentFile);
        agentStarter = AgentInitializer.createAgentStarter(agentClassLoader, inst, javaagentFile);
        if (!fromPremain || !AgentInitializer.delayAgentStart()) {
            agentStarter.start();
        }
    }

    private static boolean isEarlyOracle18() {
        String vmName = System.getProperty("java.vm.name");
        if (!vmName.contains("HotSpot") && !vmName.contains("OpenJDK")) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        if (!javaVersion.startsWith("1.8")) {
            return false;
        }
        int index = javaVersion.indexOf(95);
        if (index == -1) {
            return false;
        }
        String minorVersion = javaVersion.substring(index + 1);
        try {
            int version = Integer.parseInt(minorVersion);
            if (version >= 40) {
                return false;
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    private static boolean delayAgentStart() {
        if (!AgentInitializer.isEarlyOracle18()) {
            return false;
        }
        return agentStarter.delayStart();
    }

    public static void delayedStartHook() {
        agentStarter.start();
    }

    public static ClassLoader getExtensionsClassLoader() {
        return agentStarter != null ? agentStarter.getExtensionClassLoader() : null;
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, File javaagentFile) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        return new AgentClassLoader(javaagentFile, innerJarFilename, agentParent);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    public static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static AgentStarter createAgentStarter(ClassLoader agentClassLoader, Instrumentation instrumentation, File javaagentFile) throws Exception {
        Class<?> starterClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentStarterImpl");
        Constructor<?> constructor = starterClass.getDeclaredConstructor(Instrumentation.class, File.class);
        return (AgentStarter)constructor.newInstance(instrumentation, javaagentFile);
    }

    private AgentInitializer() {
    }
}

