/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.instrumentation.api.caching.Cache;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class HelperResources {
    private static final Cache<ClassLoader, Map<String, URL>> RESOURCES = Cache.newBuilder().setWeakKeys().build();

    public static void register(ClassLoader classLoader, String path, URL url) {
        ((Map)RESOURCES.computeIfAbsent((Object)classLoader, unused -> new ConcurrentHashMap())).put(path, url);
    }

    public static URL load(ClassLoader classLoader, String path) {
        Map map = (Map)RESOURCES.get((Object)classLoader);
        if (map == null) {
            return null;
        }
        return (URL)map.get(path);
    }

    private HelperResources() {
    }
}

