/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.jaxrs;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;

public class ClassHierarchyIterable
implements Iterable<Class<?>> {
    private final Class<?> baseClass;

    public ClassHierarchyIterable(Class<?> baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new ClassIterator();
    }

    public class ClassIterator
    implements Iterator<Class<?>> {
        @Nullable
        private Class<?> next;
        private final Set<Class<?>> queuedInterfaces = new HashSet();
        private final Queue<Class<?>> classesToExpand = new ArrayDeque();

        public ClassIterator() {
            this.classesToExpand.add(ClassHierarchyIterable.this.baseClass);
        }

        @Override
        public boolean hasNext() {
            this.calculateNextIfNecessary();
            return this.next != null;
        }

        @Override
        public Class<?> next() {
            this.calculateNextIfNecessary();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Class<?> next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void calculateNextIfNecessary() {
            if (this.next == null && !this.classesToExpand.isEmpty()) {
                this.next = this.classesToExpand.remove();
                this.queueNewInterfaces(this.next.getInterfaces());
                Class<?> superClass = this.next.getSuperclass();
                if (superClass != null) {
                    this.classesToExpand.add(this.next.getSuperclass());
                }
            }
        }

        private void queueNewInterfaces(Class[] interfaces) {
            for (Class clazz : interfaces) {
                if (!this.queuedInterfaces.add(clazz)) continue;
                this.classesToExpand.add(clazz);
            }
        }
    }
}

