/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.executors;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import javax.annotation.Nullable;

public final class ExecutorAdviceHelper {
    private static final ThreadLocal<Boolean> propagationDisabled = new ThreadLocal();

    public static void disablePropagation() {
        propagationDisabled.set(true);
    }

    public static void enablePropagation() {
        propagationDisabled.remove();
    }

    public static boolean isPropagationDisabled() {
        return propagationDisabled.get() != null;
    }

    public static boolean shouldPropagateContext(Context context, @Nullable Object task) {
        if (task == null || ExecutorAdviceHelper.isPropagationDisabled()) {
            return false;
        }
        if (context == Context.root()) {
            return false;
        }
        return InstrumentedTaskClasses.canInstrumentTaskClass(task.getClass());
    }

    public static <T> PropagatedContext attachContextToTask(Context context, VirtualField<T, PropagatedContext> virtualField, T task) {
        PropagatedContext propagatedContext = (PropagatedContext)virtualField.get(task);
        if (propagatedContext == null) {
            propagatedContext = new PropagatedContext();
            virtualField.set(task, (Object)propagatedContext);
        } else {
            Context propagated = propagatedContext.get();
            if (propagated != null && (propagated == context || ContextPropagationDebug.unwrap((Context)propagated) == context)) {
                return null;
            }
        }
        context = ContextPropagationDebug.addDebugInfo((Context)context, task);
        propagatedContext.setContext(context);
        return propagatedContext;
    }

    public static <T> void cleanUpAfterSubmit(@Nullable PropagatedContext propagatedContext, @Nullable Throwable throwable, VirtualField<T, PropagatedContext> virtualField, T task) {
        if (propagatedContext != null && throwable != null) {
            propagatedContext.clear();
            virtualField.set(task, null);
        }
    }

    public static <T> void cleanPropagatedContext(VirtualField<T, PropagatedContext> virtualField, T task) {
        if (ExecutorAdviceHelper.isPropagationDisabled()) {
            return;
        }
        PropagatedContext propagatedContext = (PropagatedContext)virtualField.get(task);
        if (propagatedContext != null) {
            propagatedContext.clear();
            virtualField.set(task, null);
        }
    }

    private ExecutorAdviceHelper() {
    }
}

