/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.concurrent;

import io.opentelemetry.context.Context;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PropagatedContext {
    private static final Logger logger = Logger.getLogger(PropagatedContext.class.getName());
    private static final AtomicReferenceFieldUpdater<PropagatedContext, Context> contextUpdater = AtomicReferenceFieldUpdater.newUpdater(PropagatedContext.class, Context.class, "context");
    private volatile Context context;

    PropagatedContext() {
    }

    void setContext(Context context) {
        Context currentPropagatedContext;
        boolean result = contextUpdater.compareAndSet(this, null, context);
        if (!result && (currentPropagatedContext = contextUpdater.get(this)) != context && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Failed to propagate context because previous propagated context is already set; new: {0}, old: {1}", new Object[]{context, currentPropagatedContext});
        }
    }

    void clear() {
        contextUpdater.set(this, null);
    }

    Context getAndClear() {
        return contextUpdater.getAndSet(this, null);
    }

    Context get() {
        return contextUpdater.get(this);
    }
}

