/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.jdbc;

import java.util.Objects;

public class DBInfo {
    public static final DBInfo DEFAULT = new Builder().build();
    private final String type;
    private final String subtype;
    private final String shortUrl;
    private final String user;
    private final String instance;
    private final String db;
    private final String host;
    private final Integer port;

    public DBInfo(String type, String subtype, String shortUrl, String user, String instance, String db, String host, Integer port) {
        this.type = type;
        this.subtype = subtype;
        this.shortUrl = shortUrl;
        this.user = user;
        this.instance = instance;
        this.db = db;
        this.host = host;
        this.port = port;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDb() {
        return this.db;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Builder toBuilder() {
        return new Builder().type(this.type).subtype(this.subtype).shortUrl(this.shortUrl).user(this.user).instance(this.instance).db(this.db).host(this.host).port(this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBInfo)) {
            return false;
        }
        DBInfo dbInfo = (DBInfo)o;
        return Objects.equals(this.type, dbInfo.type) && Objects.equals(this.subtype, dbInfo.subtype) && Objects.equals(this.shortUrl, dbInfo.shortUrl) && Objects.equals(this.user, dbInfo.user) && Objects.equals(this.instance, dbInfo.instance) && Objects.equals(this.db, dbInfo.db) && Objects.equals(this.host, dbInfo.host) && Objects.equals(this.port, dbInfo.port);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.shortUrl, this.user, this.instance, this.db, this.host, this.port);
    }

    public static class Builder {
        private String type;
        private String subtype;
        private String shortUrl;
        private String user;
        private String instance;
        private String db;
        private String host;
        private Integer port;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public Builder shortUrl(String shortUrl) {
            this.shortUrl = shortUrl;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder instance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public DBInfo build() {
            return new DBInfo(this.type, this.subtype, this.shortUrl, this.user, this.instance, this.db, this.host, this.port);
        }
    }
}

