/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent;

import io.grpc.Context;
import io.opentelemetry.auto.bootstrap.ContextStore;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    private static final Logger log = LoggerFactory.getLogger(State.class);
    public static ContextStore.Factory<State> FACTORY = new ContextStore.Factory<State>(){

        @Override
        public State create() {
            return new State();
        }
    };
    private final AtomicReference<Context> parentContextRef = new AtomicReference<Object>(null);

    private State() {
    }

    public void setParentSpan(Context parentContext) {
        boolean result = this.parentContextRef.compareAndSet(null, parentContext);
        if (!result && this.parentContextRef.get() != parentContext && log.isDebugEnabled()) {
            log.debug("Failed to set parent context because another parent context is already set {}: new: {}, old: {}", new Object[]{this, parentContext, this.parentContextRef.get()});
        }
    }

    public void clearParentContext() {
        this.parentContextRef.set(null);
    }

    public Context getAndResetParentContext() {
        return this.parentContextRef.getAndSet(null);
    }
}

