/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent;

import io.grpc.Context;
import io.opentelemetry.auto.bootstrap.ContextStore;
import io.opentelemetry.auto.bootstrap.WeakMap;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.AdviceUtils;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.CallableWrapper;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.RunnableWrapper;
import io.opentelemetry.auto.bootstrap.instrumentation.java.concurrent.State;
import io.opentelemetry.trace.Span;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorInstrumentationUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorInstrumentationUtils.class);
    private static final WeakMap<Executor, Boolean> EXECUTORS_DISABLED_FOR_WRAPPED_TASKS = WeakMap.Provider.newWeakMap();

    public static boolean shouldAttachStateToTask(Object task, Executor executor) {
        if (task == null) {
            return false;
        }
        Span span = AdviceUtils.TRACER.getCurrentSpan();
        Class<?> enclosingClass = task.getClass().getEnclosingClass();
        return span.getContext().isValid() && !ExecutorInstrumentationUtils.isExecutorDisabledForThisTask(executor, task) && (enclosingClass == null || !enclosingClass.getName().equals("io.netty.util.concurrent.SingleThreadEventExecutor"));
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, Context context) {
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        state.setParentSpan(context);
        return state;
    }

    public static void cleanUpOnMethodExit(State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.clearParentContext();
        }
    }

    public static void disableExecutorForWrappedTasks(Executor executor) {
        log.debug("Disabling Executor tracing for wrapped tasks for instance {}", (Object)executor);
        EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.put(executor, true);
    }

    public static boolean isExecutorDisabledForThisTask(Executor executor, Object task) {
        return (task instanceof RunnableWrapper || task instanceof CallableWrapper) && EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.containsKey(executor);
    }
}

