/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.opentelemetry.auto.bootstrap.instrumentation.decorator.ClientDecorator;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.HttpStatusConverter;
import io.opentelemetry.auto.config.Config;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientDecorator<REQUEST, RESPONSE>
extends ClientDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDecorator.class);
    public static final String DEFAULT_SPAN_NAME = "HTTP request";
    protected static final String USER_AGENT = "User-Agent";

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract Integer status(RESPONSE var1);

    protected abstract String requestHeader(REQUEST var1, String var2);

    protected abstract String responseHeader(RESPONSE var1, String var2);

    public Span getOrCreateSpan(REQUEST request, Tracer tracer) {
        return HttpClientDecorator.getOrCreateSpan(this.spanNameForRequest(request), tracer);
    }

    public String spanNameForRequest(REQUEST request) {
        if (request == null) {
            return DEFAULT_SPAN_NAME;
        }
        String method = this.method(request);
        return method != null ? "HTTP " + method : DEFAULT_SPAN_NAME;
    }

    public Span onRequest(Span span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setAttribute(SemanticAttributes.HTTP_METHOD.key(), this.method(request));
            String userAgent = this.requestHeader(request, USER_AGENT);
            if (userAgent != null) {
                SemanticAttributes.HTTP_USER_AGENT.set(span, userAgent);
            }
            try {
                URI url = this.url(request);
                if (url != null) {
                    String fragment;
                    String path;
                    StringBuilder urlBuilder = new StringBuilder();
                    if (url.getScheme() != null) {
                        urlBuilder.append(url.getScheme());
                        urlBuilder.append("://");
                    }
                    if (url.getHost() != null) {
                        urlBuilder.append(url.getHost());
                        HttpClientDecorator.setPeer(span, url.getHost(), null);
                        if (url.getPort() > 0) {
                            span.setAttribute(SemanticAttributes.NET_PEER_PORT.key(), (long)url.getPort());
                            if (url.getPort() != 80 && url.getPort() != 443) {
                                urlBuilder.append(":");
                                urlBuilder.append(url.getPort());
                            }
                        }
                    }
                    if ((path = url.getPath()).isEmpty()) {
                        urlBuilder.append("/");
                    } else {
                        urlBuilder.append(path);
                    }
                    String query = url.getQuery();
                    if (query != null) {
                        urlBuilder.append("?").append(query);
                    }
                    if ((fragment = url.getFragment()) != null) {
                        urlBuilder.append("#").append(fragment);
                    }
                    span.setAttribute(SemanticAttributes.HTTP_URL.key(), urlBuilder.toString());
                    if (Config.get().isHttpClientTagQueryString()) {
                        span.setAttribute("http.query.string", query);
                        span.setAttribute("http.fragment.string", fragment);
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", (Throwable)e);
            }
        }
        return span;
    }

    public Span onResponse(Span span, RESPONSE response) {
        Integer status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE.key(), (long)status.intValue());
            span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
        }
        return span;
    }
}

