/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap.instrumentation.decorator;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.auto.bootstrap.instrumentation.decorator.BaseDecorator;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.Tracer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;

public abstract class BaseTracer {
    public static final Context.Key<Span> CONTEXT_SERVER_SPAN_KEY = Context.key((String)"opentelemetry-trace-server-span-key");
    protected final Tracer tracer;

    public BaseTracer() {
        this.tracer = OpenTelemetry.getTracerProvider().get(this.getInstrumentationName(), this.getVersion());
    }

    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Span startSpan(Class<?> clazz) {
        String spanName = this.spanNameForClass(clazz);
        return this.startSpan(spanName);
    }

    public Span startSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).startSpan();
    }

    public Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public static Span getCurrentServerSpan() {
        return (Span)CONTEXT_SERVER_SPAN_KEY.get(Context.current());
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return null;
    }

    protected String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    protected String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    protected String spanNameForMethod(Class<?> cl, String methodName) {
        return this.spanNameForClass(cl) + "." + methodName;
    }

    protected String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }

    public void end(Span span) {
        span.end();
    }

    public void endExceptionally(Span span, Throwable throwable) {
        this.onError(span, this.unwrapThrowable(throwable));
        span.setStatus(Status.INTERNAL);
        this.end(span);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.setAttribute("error.msg", throwable.getMessage());
        span.setAttribute("error.type", throwable.getClass().getName());
        StringWriter errorString = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errorString));
        span.setAttribute("error.stack", errorString.toString());
    }

    public static void setPeer(Span span, String peerName, String peerIp) {
        BaseDecorator.setPeer(span, peerName, peerIp);
    }
}

