/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.auto.bootstrap;

public class CallDepthThreadLocalMap {
    private static final ClassValue<ThreadLocalDepth> TLS = new ClassValue<ThreadLocalDepth>(){

        @Override
        protected ThreadLocalDepth computeValue(Class<?> type) {
            return new ThreadLocalDepth();
        }
    };

    public static Depth getCallDepth(Class<?> k) {
        return (Depth)TLS.get(k).get();
    }

    public static int incrementCallDepth(Class<?> k) {
        return ((Depth)TLS.get(k).get()).getAndIncrement();
    }

    public static int decrementCallDepth(Class<?> k) {
        return ((Depth)TLS.get(k).get()).decrementAndGet();
    }

    public static void reset(Class<?> k) {
        ((Depth)TLS.get(k).get()).depth = 0;
    }

    private static final class ThreadLocalDepth
    extends ThreadLocal<Depth> {
        private ThreadLocalDepth() {
        }

        @Override
        protected Depth initialValue() {
            return new Depth();
        }
    }

    public static final class Depth {
        private int depth = 0;

        private Depth() {
        }

        public int getAndIncrement() {
            return this.depth++;
        }

        public int decrementAndGet() {
            return --this.depth;
        }
    }
}

