/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.metrics.micrometer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.contrib.metrics.micrometer.CallbackRegistrar;
import io.opentelemetry.contrib.metrics.micrometer.ScheduledCallbackRegistrar;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ScheduledCallbackRegistrarBuilder {
    private final ScheduledExecutorService scheduledExecutorService;
    private long period;
    private TimeUnit timeUnit;
    private boolean shutdownExecutorOnClose;

    ScheduledCallbackRegistrarBuilder(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.period = 1L;
        this.timeUnit = TimeUnit.SECONDS;
    }

    @CanIgnoreReturnValue
    public ScheduledCallbackRegistrarBuilder setPeriod(long period, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        this.period = period;
        this.timeUnit = unit;
        return this;
    }

    @CanIgnoreReturnValue
    public ScheduledCallbackRegistrarBuilder setPeriod(Duration period) {
        Objects.requireNonNull(period, "period");
        this.period = period.toMillis();
        this.timeUnit = TimeUnit.MILLISECONDS;
        return this;
    }

    @CanIgnoreReturnValue
    public ScheduledCallbackRegistrarBuilder setShutdownExecutorOnClose(boolean shutdownExecutorOnClose) {
        this.shutdownExecutorOnClose = shutdownExecutorOnClose;
        return this;
    }

    public CallbackRegistrar build() {
        return new ScheduledCallbackRegistrar(this.scheduledExecutorService, this.period, this.timeUnit, this.shutdownExecutorOnClose);
    }
}

