/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.storage;

import io.opentelemetry.contrib.disk.buffering.internal.storage.FolderManager;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.ReadableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.files.WritableFile;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.ReadableResult;
import io.opentelemetry.contrib.disk.buffering.internal.storage.responses.WritableResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class Storage
implements Closeable {
    private final FolderManager folderManager;
    @Nullable
    private WritableFile writableFile;
    @Nullable
    private ReadableFile readableFile;
    private static final int MAX_ATTEMPTS = 3;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public Storage(FolderManager folderManager) {
        this.folderManager = folderManager;
    }

    public boolean write(byte[] item) throws IOException {
        return this.write(item, 1);
    }

    private boolean write(byte[] item, int attemptNumber) throws IOException {
        WritableResult result;
        if (this.isClosed.get()) {
            return false;
        }
        if (attemptNumber > 3) {
            return false;
        }
        if (this.writableFile == null) {
            this.writableFile = this.folderManager.createWritableFile();
        }
        if ((result = this.writableFile.append(item)) != WritableResult.SUCCEEDED) {
            this.writableFile = null;
            return this.write(item, ++attemptNumber);
        }
        return true;
    }

    public ReadableResult readAndProcess(Function<byte[], Boolean> processing) throws IOException {
        return this.readAndProcess(processing, 1);
    }

    private ReadableResult readAndProcess(Function<byte[], Boolean> processing, int attemptNumber) throws IOException {
        if (this.isClosed.get()) {
            return ReadableResult.FAILED;
        }
        if (attemptNumber > 3) {
            return ReadableResult.FAILED;
        }
        if (this.readableFile == null) {
            this.readableFile = this.folderManager.getReadableFile();
            if (this.readableFile == null) {
                return ReadableResult.FAILED;
            }
        }
        ReadableResult result = this.readableFile.readAndProcess(processing);
        switch (result) {
            case SUCCEEDED: 
            case PROCESSING_FAILED: {
                return result;
            }
        }
        this.readableFile = null;
        return this.readAndProcess(processing, ++attemptNumber);
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.compareAndSet(false, true)) {
            if (this.writableFile != null) {
                this.writableFile.close();
            }
            if (this.readableFile != null) {
                this.readableFile.close();
            }
        }
    }
}

