/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers;

import com.google.protobuf.InvalidProtocolBufferException;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.metrics.ProtoMetricsDataMapper;
import io.opentelemetry.contrib.disk.buffering.internal.serialization.serializers.SignalSerializer;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public final class MetricDataSerializer
implements SignalSerializer<MetricData> {
    private static final MetricDataSerializer INSTANCE = new MetricDataSerializer();

    private MetricDataSerializer() {
    }

    static MetricDataSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Collection<MetricData> metricData) {
        byte[] byArray;
        MetricsData proto = (MetricsData)ProtoMetricsDataMapper.getInstance().toProto(metricData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            proto.writeDelimitedTo((OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public List<MetricData> deserialize(byte[] source) {
        try {
            return ProtoMetricsDataMapper.getInstance().fromProto(MetricsData.parseFrom((byte[])source));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

