/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.disk.buffering.internal.serialization.mapping.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.ArrayValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.util.ArrayList;
import java.util.List;

public final class AttributesMapper {
    private static final AttributesMapper INSTANCE = new AttributesMapper();

    public static AttributesMapper getInstance() {
        return INSTANCE;
    }

    public List<KeyValue> attributesToProto(Attributes attributes) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        attributes.forEach((attributeKey, o) -> keyValues.add(AttributesMapper.attributeEntryToProto(attributeKey, o)));
        return keyValues;
    }

    public Attributes protoToAttributes(List<KeyValue> values) {
        AttributesBuilder builder = Attributes.builder();
        for (KeyValue keyValue : values) {
            AttributesMapper.addValue(builder, keyValue.getKey(), keyValue.getValue());
        }
        return builder.build();
    }

    private static KeyValue attributeEntryToProto(AttributeKey<?> key, Object value) {
        KeyValue.Builder builder = KeyValue.newBuilder();
        builder.setKey(key.getKey());
        builder.setValue(AttributesMapper.attributeValueToProto(key.getType(), value));
        return builder.build();
    }

    private static AnyValue attributeValueToProto(AttributeType type, Object value) {
        switch (type) {
            case STRING: {
                return AttributesMapper.stringToAnyValue((String)value);
            }
            case BOOLEAN: {
                return AttributesMapper.booleanToAnyValue((Boolean)value);
            }
            case LONG: {
                return AttributesMapper.longToAnyValue((Long)value);
            }
            case DOUBLE: {
                return AttributesMapper.doubleToAnyValue((Double)value);
            }
            case STRING_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.stringListToAnyValue((List)value));
            }
            case BOOLEAN_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.booleanListToAnyValue((List)value));
            }
            case LONG_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.longListToAnyValue((List)value));
            }
            case DOUBLE_ARRAY: {
                return AttributesMapper.arrayToAnyValue(AttributesMapper.doubleListToAnyValue((List)value));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static AnyValue arrayToAnyValue(List<AnyValue> value) {
        return AnyValue.newBuilder().setArrayValue(ArrayValue.newBuilder().addAllValues(value).build()).build();
    }

    private static void addValue(AttributesBuilder builder, String key, AnyValue value) {
        if (value.hasStringValue()) {
            builder.put(AttributeKey.stringKey((String)key), (Object)value.getStringValue());
        } else if (value.hasBoolValue()) {
            builder.put(AttributeKey.booleanKey((String)key), (Object)value.getBoolValue());
        } else if (value.hasIntValue()) {
            builder.put(AttributeKey.longKey((String)key), (Object)value.getIntValue());
        } else if (value.hasDoubleValue()) {
            builder.put(AttributeKey.doubleKey((String)key), (Object)value.getDoubleValue());
        } else if (value.hasArrayValue()) {
            AttributesMapper.addArray(builder, key, value.getArrayValue());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static void addArray(AttributesBuilder builder, String key, ArrayValue arrayValue) {
        List values = arrayValue.getValuesList();
        AnyValue anyValue = (AnyValue)values.get(0);
        if (anyValue.hasStringValue()) {
            builder.put(AttributeKey.stringArrayKey((String)key), AttributesMapper.anyValuesToStrings(values));
        } else if (anyValue.hasBoolValue()) {
            builder.put(AttributeKey.booleanArrayKey((String)key), AttributesMapper.anyValuesToBooleans(values));
        } else if (anyValue.hasIntValue()) {
            builder.put(AttributeKey.longArrayKey((String)key), AttributesMapper.anyValuesToLongs(values));
        } else if (anyValue.hasDoubleValue()) {
            builder.put(AttributeKey.doubleArrayKey((String)key), AttributesMapper.anyValuesToDoubles(values));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static AnyValue stringToAnyValue(String value) {
        AnyValue.Builder anyValue = AnyValue.newBuilder();
        anyValue.setStringValue(value);
        return anyValue.build();
    }

    private static AnyValue booleanToAnyValue(Boolean value) {
        AnyValue.Builder anyValue = AnyValue.newBuilder();
        if (value != null) {
            anyValue.setBoolValue(value.booleanValue());
        }
        return anyValue.build();
    }

    private static AnyValue longToAnyValue(Long value) {
        AnyValue.Builder anyValue = AnyValue.newBuilder();
        if (value != null) {
            anyValue.setIntValue(value.longValue());
        }
        return anyValue.build();
    }

    private static AnyValue doubleToAnyValue(Double value) {
        AnyValue.Builder anyValue = AnyValue.newBuilder();
        if (value != null) {
            anyValue.setDoubleValue(value.doubleValue());
        }
        return anyValue.build();
    }

    private static List<AnyValue> stringListToAnyValue(List<String> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (String string : value) {
            list.add(AttributesMapper.stringToAnyValue(string));
        }
        return list;
    }

    private static List<AnyValue> booleanListToAnyValue(List<Boolean> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Boolean boolean1 : value) {
            list.add(AttributesMapper.booleanToAnyValue(boolean1));
        }
        return list;
    }

    private static List<AnyValue> longListToAnyValue(List<Long> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Long long1 : value) {
            list.add(AttributesMapper.longToAnyValue(long1));
        }
        return list;
    }

    private static List<AnyValue> doubleListToAnyValue(List<Double> value) {
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(value.size());
        for (Double double1 : value) {
            list.add(AttributesMapper.doubleToAnyValue(double1));
        }
        return list;
    }

    private static List<String> anyValuesToStrings(List<AnyValue> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToString(anyValue));
        }
        return list;
    }

    private static List<Boolean> anyValuesToBooleans(List<AnyValue> values) {
        ArrayList<Boolean> list = new ArrayList<Boolean>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToBoolean(anyValue));
        }
        return list;
    }

    private static List<Long> anyValuesToLongs(List<AnyValue> values) {
        ArrayList<Long> list = new ArrayList<Long>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToLong(anyValue));
        }
        return list;
    }

    private static List<Double> anyValuesToDoubles(List<AnyValue> values) {
        ArrayList<Double> list = new ArrayList<Double>(values.size());
        for (AnyValue anyValue : values) {
            list.add(AttributesMapper.anyValueToDouble(anyValue));
        }
        return list;
    }

    private static String anyValueToString(AnyValue value) {
        return value.getStringValue();
    }

    private static Boolean anyValueToBoolean(AnyValue value) {
        return value.getBoolValue();
    }

    private static Long anyValueToLong(AnyValue value) {
        return value.getIntValue();
    }

    private static Double anyValueToDouble(AnyValue value) {
        return value.getDoubleValue();
    }
}

