/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;

public abstract class ConsistentThresholdSampler
extends ConsistentSampler {
    protected abstract long getThreshold();

    protected static long getThreshold(long threshold) {
        ConsistentSamplingUtil.checkThreshold(threshold);
        return threshold;
    }

    protected static String getThresholdDescription(long threshold) {
        String thresholdString = threshold == ConsistentSamplingUtil.getMaxThreshold() ? "max" : ConsistentSamplingUtil.appendLast56BitHexEncodedWithoutTrailingZeros(new StringBuilder(), threshold).toString();
        return "ConsistentFixedThresholdSampler{threshold=" + thresholdString + ", sampling probability=" + ConsistentSamplingUtil.calculateSamplingProbability(threshold) + "}";
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return () -> {
            if (this.getThreshold() == ConsistentSamplingUtil.getMaxThreshold()) {
                return ConsistentSamplingUtil.getInvalidThreshold();
            }
            return this.getThreshold();
        };
    }
}

