/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class OtelTraceState {
    public static final String TRACE_STATE_KEY = "ot";
    private static final char P_SUBKEY = 'p';
    private static final char R_SUBKEY = 'r';
    private static final int MAX_P = 63;
    private static final int MAX_R = 62;
    private static final int INVALID_P = -1;
    private static final int INVALID_R = -1;
    private static final int TRACE_STATE_SIZE_LIMIT = 256;
    private int rval;
    private int pval;
    private final List<String> otherKeyValuePairs;

    private OtelTraceState(int rvalue, int pvalue, List<String> otherKeyValuePairs) {
        this.rval = rvalue;
        this.pval = pvalue;
        this.otherKeyValuePairs = otherKeyValuePairs;
    }

    private OtelTraceState() {
        this(-1, -1, Collections.emptyList());
    }

    public boolean hasValidR() {
        return OtelTraceState.isValidR(this.rval);
    }

    public boolean hasValidP() {
        return OtelTraceState.isValidP(this.pval);
    }

    public void invalidateP() {
        this.pval = -1;
    }

    public void invalidateR() {
        this.rval = -1;
    }

    public void setP(int pval) {
        if (OtelTraceState.isValidP(pval)) {
            this.pval = pval;
        } else {
            this.invalidateP();
        }
    }

    public void setR(int rval) {
        if (OtelTraceState.isValidR(rval)) {
            this.rval = rval;
        } else {
            this.invalidateR();
        }
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        if (this.hasValidP()) {
            sb.append("p:").append(this.pval);
        }
        if (this.hasValidR()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("r:").append(this.rval);
        }
        for (String pair : this.otherKeyValuePairs) {
            int ex = sb.length();
            if (ex != 0) {
                ++ex;
            }
            if (ex + pair.length() > 256) break;
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(pair);
        }
        return sb.toString();
    }

    private static boolean isValueByte(char c) {
        return OtelTraceState.isLowerCaseAlphaNum(c) || OtelTraceState.isUpperCaseAlpha(c) || c == '.' || c == '_' || c == '-';
    }

    private static boolean isLowerCaseAlphaNum(char c) {
        return OtelTraceState.isLowerCaseAlpha(c) || OtelTraceState.isDigit(c);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerCaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static int parseOneOrTwoDigitNumber(String ts, int from, int to, int twoDigitMaxValue, int invalidValue) {
        if (to - from == 1) {
            char c = ts.charAt(from);
            if (OtelTraceState.isDigit(c)) {
                return c - 48;
            }
        } else if (to - from == 2) {
            int v;
            char c1 = ts.charAt(from);
            char c2 = ts.charAt(from + 1);
            if (OtelTraceState.isDigit(c1) && OtelTraceState.isDigit(c2) && (v = (c1 - 48) * 10 + (c2 - 48)) <= twoDigitMaxValue) {
                return v;
            }
        }
        return invalidValue;
    }

    public static boolean isValidR(int v) {
        return 0 <= v && v <= 62;
    }

    public static boolean isValidP(int v) {
        return 0 <= v && v <= 63;
    }

    public static OtelTraceState parse(@Nullable String ts) {
        int r;
        int p;
        ArrayList<String> otherKeyValuePairs;
        block12: {
            int separatorPos;
            otherKeyValuePairs = null;
            p = -1;
            r = -1;
            if (ts == null || ts.isEmpty()) {
                return new OtelTraceState();
            }
            if (ts.length() > 256) {
                return new OtelTraceState();
            }
            int startPos = 0;
            int len = ts.length();
            do {
                char c;
                int colonPos;
                for (colonPos = startPos; colonPos < len && (OtelTraceState.isLowerCaseAlpha(c = ts.charAt(colonPos)) || OtelTraceState.isDigit(c) && colonPos != startPos); ++colonPos) {
                }
                if (colonPos == startPos || colonPos == len || ts.charAt(colonPos) != ':') {
                    return new OtelTraceState();
                }
                for (separatorPos = colonPos + 1; separatorPos < len && OtelTraceState.isValueByte(ts.charAt(separatorPos)); ++separatorPos) {
                }
                if (colonPos - startPos == 1 && ts.charAt(startPos) == 'p') {
                    p = OtelTraceState.parseOneOrTwoDigitNumber(ts, colonPos + 1, separatorPos, 63, -1);
                } else if (colonPos - startPos == 1 && ts.charAt(startPos) == 'r') {
                    r = OtelTraceState.parseOneOrTwoDigitNumber(ts, colonPos + 1, separatorPos, 62, -1);
                } else {
                    if (otherKeyValuePairs == null) {
                        otherKeyValuePairs = new ArrayList<String>();
                    }
                    otherKeyValuePairs.add(ts.substring(startPos, separatorPos));
                }
                if (separatorPos < len && ts.charAt(separatorPos) != ';') {
                    return new OtelTraceState();
                }
                if (separatorPos == len) break block12;
            } while ((startPos = separatorPos + 1) != len);
            return new OtelTraceState();
        }
        return new OtelTraceState(r, p, otherKeyValuePairs != null ? otherKeyValuePairs : Collections.emptyList());
    }

    public int getR() {
        return this.rval;
    }

    public int getP() {
        return this.pval;
    }

    public static int getMaxP() {
        return 63;
    }

    public static int getMaxR() {
        return 62;
    }

    public static int getInvalidR() {
        return -1;
    }

    public static int getInvalidP() {
        return -1;
    }
}

