/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent;

import io.opentelemetry.contrib.sampler.consistent.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent.OtelTraceState;
import io.opentelemetry.contrib.sampler.consistent.RValueGenerator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentComposedOrSampler
extends ConsistentSampler {
    private final ConsistentSampler sampler1;
    private final ConsistentSampler sampler2;
    private final String description;

    ConsistentComposedOrSampler(ConsistentSampler sampler1, ConsistentSampler sampler2, RValueGenerator rValueGenerator) {
        super(rValueGenerator);
        this.sampler1 = Objects.requireNonNull(sampler1);
        this.sampler2 = Objects.requireNonNull(sampler2);
        this.description = "ConsistentComposedOrSampler{sampler1=" + sampler1.getDescription() + ",sampler2=" + sampler2.getDescription() + '}';
    }

    @Override
    protected int getP(int parentP, boolean isRoot) {
        int p1 = this.sampler1.getP(parentP, isRoot);
        int p2 = this.sampler2.getP(parentP, isRoot);
        if (OtelTraceState.isValidP(p1)) {
            if (OtelTraceState.isValidP(p2)) {
                return Math.min(p1, p2);
            }
            return p1;
        }
        if (OtelTraceState.isValidP(p2)) {
            return p2;
        }
        return OtelTraceState.getInvalidP();
    }

    public String getDescription() {
        return this.description;
    }
}

