/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.PredicatedSampler;
import io.opentelemetry.contrib.sampler.consistent56.SamplingIntent;
import io.opentelemetry.sdk.trace.data.LinkData;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ConsistentRuleBasedSampler
extends ConsistentSampler {
    @Nullable
    private final SpanKind spanKindToMatch;
    private final PredicatedSampler[] samplers;
    private final String description;

    ConsistentRuleBasedSampler(@Nullable SpanKind spanKindToMatch, PredicatedSampler ... samplers) {
        this.spanKindToMatch = spanKindToMatch;
        this.samplers = samplers != null ? samplers : new PredicatedSampler[]{};
        this.description = Stream.of(samplers).map(s -> s.getSampler().getDescription()).collect(Collectors.joining(",", "ConsistentRuleBasedSampler{", "}"));
    }

    @Override
    public SamplingIntent getSamplingIntent(Context parentContext, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        if (this.spanKindToMatch == null || this.spanKindToMatch == spanKind) {
            for (PredicatedSampler delegate : this.samplers) {
                if (!delegate.getPredicate().spanMatches(parentContext, name, spanKind, attributes, parentLinks)) continue;
                return delegate.getSampler().getSamplingIntent(parentContext, name, spanKind, attributes, parentLinks);
            }
        }
        return () -> ConsistentSamplingUtil.getInvalidThreshold();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

