/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.sampler.consistent56;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOffSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentAlwaysOnSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentComposedAndSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentComposedOrSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentFixedThresholdSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentParentBasedSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentRateLimitingSampler;
import io.opentelemetry.contrib.sampler.consistent56.ConsistentSamplingUtil;
import io.opentelemetry.contrib.sampler.consistent56.OtelTraceState;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import java.util.function.LongSupplier;

public abstract class ConsistentSampler
implements Sampler {
    public static ConsistentSampler alwaysOn() {
        return ConsistentAlwaysOnSampler.getInstance();
    }

    public static ConsistentSampler alwaysOff() {
        return ConsistentAlwaysOffSampler.getInstance();
    }

    public static ConsistentSampler probabilityBased(double samplingProbability) {
        long threshold = ConsistentSamplingUtil.calculateThreshold(samplingProbability);
        return new ConsistentFixedThresholdSampler(threshold);
    }

    public static ConsistentSampler parentBased(ConsistentSampler rootSampler) {
        return new ConsistentParentBasedSampler(rootSampler);
    }

    public static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds) {
        return ConsistentSampler.rateLimited(targetSpansPerSecondLimit, adaptationTimeSeconds, System::nanoTime);
    }

    static ConsistentSampler rateLimited(double targetSpansPerSecondLimit, double adaptationTimeSeconds, LongSupplier nanoTimeSupplier) {
        return new ConsistentRateLimitingSampler(targetSpansPerSecondLimit, adaptationTimeSeconds, nanoTimeSupplier);
    }

    public ConsistentSampler and(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedAndSampler(this, otherConsistentSampler);
    }

    public ConsistentSampler or(ConsistentSampler otherConsistentSampler) {
        if (otherConsistentSampler == this) {
            return this;
        }
        return new ConsistentComposedOrSampler(this, otherConsistentSampler);
    }

    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        boolean isSampled;
        long threshold;
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        boolean isRoot = !parentSpanContext.isValid();
        boolean isParentSampled = parentSpanContext.isSampled();
        TraceState parentTraceState = parentSpanContext.getTraceState();
        String otelTraceStateString = parentTraceState.get("ot");
        OtelTraceState otelTraceState = OtelTraceState.parse(otelTraceStateString);
        long randomValue = otelTraceState.hasValidRandomValue() ? otelTraceState.getRandomValue() : OtelTraceState.parseHex(traceId, 18, 14, ConsistentSamplingUtil.getInvalidRandomValue());
        long parentThreshold = otelTraceState.hasValidThreshold() ? (randomValue >= (threshold = otelTraceState.getThreshold()) == isParentSampled ? threshold : ConsistentSamplingUtil.getInvalidThreshold()) : ConsistentSamplingUtil.getInvalidThreshold();
        threshold = this.getThreshold(parentThreshold, isRoot);
        if (ConsistentSamplingUtil.isValidThreshold(threshold)) {
            boolean bl = isSampled = randomValue >= threshold;
            if (isSampled) {
                otelTraceState.setThreshold(threshold);
            } else {
                otelTraceState.invalidateThreshold();
            }
        } else {
            isSampled = isParentSampled;
            otelTraceState.invalidateThreshold();
        }
        final SamplingDecision samplingDecision = isSampled ? SamplingDecision.RECORD_AND_SAMPLE : SamplingDecision.DROP;
        final String newOtTraceState = otelTraceState.serialize();
        return new SamplingResult(){

            public SamplingDecision getDecision() {
                return samplingDecision;
            }

            public Attributes getAttributes() {
                return Attributes.empty();
            }

            public TraceState getUpdatedTraceState(TraceState parentTraceState) {
                return parentTraceState.toBuilder().put("ot", newOtTraceState).build();
            }
        };
    }

    protected abstract long getThreshold(long var1, boolean var3);
}

