/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.cloudfoundry.resources;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.function.Function;
import java.util.logging.Logger;

public final class CloudFoundryResource {
    private static final String ENV_VCAP_APPLICATION = "VCAP_APPLICATION";
    private static final AttributeKey<String> CLOUDFOUNDRY_APP_ID = AttributeKey.stringKey((String)"cloudfoundry.app.id");
    private static final AttributeKey<String> CLOUDFOUNDRY_APP_INSTANCE_ID = AttributeKey.stringKey((String)"cloudfoundry.app.instance.id");
    private static final AttributeKey<String> CLOUDFOUNDRY_APP_NAME = AttributeKey.stringKey((String)"cloudfoundry.app.name");
    private static final AttributeKey<String> CLOUDFOUNDRY_ORG_ID = AttributeKey.stringKey((String)"cloudfoundry.org.id");
    private static final AttributeKey<String> CLOUDFOUNDRY_ORG_NAME = AttributeKey.stringKey((String)"cloudfoundry.org.name");
    private static final AttributeKey<String> CLOUDFOUNDRY_PROCESS_ID = AttributeKey.stringKey((String)"cloudfoundry.process.id");
    private static final AttributeKey<String> CLOUDFOUNDRY_PROCESS_TYPE = AttributeKey.stringKey((String)"cloudfoundry.process.type");
    private static final AttributeKey<String> CLOUDFOUNDRY_SPACE_ID = AttributeKey.stringKey((String)"cloudfoundry.space.id");
    private static final AttributeKey<String> CLOUDFOUNDRY_SPACE_NAME = AttributeKey.stringKey((String)"cloudfoundry.space.name");
    private static final Logger LOG = Logger.getLogger(CloudFoundryResource.class.getName());
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final Resource INSTANCE = CloudFoundryResource.buildResource(System::getenv);

    private CloudFoundryResource() {
    }

    public static Resource get() {
        return INSTANCE;
    }

    static Resource buildResource(Function<String, String> getenv) {
        String vcapAppRaw = getenv.apply(ENV_VCAP_APPLICATION);
        if (vcapAppRaw == null || vcapAppRaw.isEmpty()) {
            return Resource.empty();
        }
        AttributesBuilder builder = Attributes.builder();
        try (JsonParser parser = JSON_FACTORY.createParser(vcapAppRaw);){
            parser.nextToken();
            block29: while (parser.nextToken() != JsonToken.END_OBJECT) {
                String name = parser.currentName();
                parser.nextToken();
                String value = parser.getValueAsString();
                switch (name) {
                    case "application_id": {
                        builder.put(CLOUDFOUNDRY_APP_ID, (Object)value);
                        continue block29;
                    }
                    case "application_name": {
                        builder.put(CLOUDFOUNDRY_APP_NAME, (Object)value);
                        continue block29;
                    }
                    case "instance_index": {
                        builder.put(CLOUDFOUNDRY_APP_INSTANCE_ID, (Object)value);
                        continue block29;
                    }
                    case "organization_id": {
                        builder.put(CLOUDFOUNDRY_ORG_ID, (Object)value);
                        continue block29;
                    }
                    case "organization_name": {
                        builder.put(CLOUDFOUNDRY_ORG_NAME, (Object)value);
                        continue block29;
                    }
                    case "process_id": {
                        builder.put(CLOUDFOUNDRY_PROCESS_ID, (Object)value);
                        continue block29;
                    }
                    case "process_type": {
                        builder.put(CLOUDFOUNDRY_PROCESS_TYPE, (Object)value);
                        continue block29;
                    }
                    case "space_id": {
                        builder.put(CLOUDFOUNDRY_SPACE_ID, (Object)value);
                        continue block29;
                    }
                    case "space_name": {
                        builder.put(CLOUDFOUNDRY_SPACE_NAME, (Object)value);
                        continue block29;
                    }
                }
                parser.skipChildren();
            }
        }
        catch (IOException e) {
            LOG.warning("Cannot parse contents of environment variable VCAP_APPLICATION. Invalid JSON");
        }
        return Resource.create((Attributes)builder.build(), (String)"https://opentelemetry.io/schemas/1.24.0");
    }
}

