/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.baggage.processor;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.function.Predicate;

public class BaggageSpanProcessor
implements SpanProcessor {
    private final Predicate<String> baggageKeyPredicate;
    public static final Predicate<String> allowAllBaggageKeys = baggageKey -> true;

    public BaggageSpanProcessor(Predicate<String> baggageKeyPredicate) {
        this.baggageKeyPredicate = baggageKeyPredicate;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        Baggage.fromContext((Context)parentContext).forEach((s, baggageEntry) -> {
            if (this.baggageKeyPredicate.test((String)s)) {
                span.setAttribute(s, baggageEntry.getValue());
            }
        });
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return false;
    }
}

