/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.deser;

import io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonParser;
import io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonToken;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.DeserializationContext;
import io.openlineage.spark.shade.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;
import java.util.function.BiConsumer;

final class SettableObjectProperty
extends OptimizedSettableBeanProperty<SettableObjectProperty> {
    private static final long serialVersionUID = 1L;
    private BiConsumer<Object, Object> _optimizedSetter;

    public SettableObjectProperty(SettableBeanProperty src, BiConsumer<Object, Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableObjectProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        this.set(bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        return this.setAndReturn(instance, value);
    }

    @Override
    public void set(Object bean, Object v) throws IOException {
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }
}

